/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.features;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.GPKG12;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FeaturesTests
extends CommonFixture {
    private static final Collection<String> ALLOWED_GEOMETRY_TYPES = Arrays.asList("GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION");
    private final Collection<String> featureTableNames = new ArrayList<String>();

    @BeforeClass
    public void setUp() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features';");){
            while (resultSet.next()) {
                this.featureTableNames.add(resultSet.getString(1));
            }
        }
        Assert.assertTrue((!this.featureTableNames.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassNotUsed", this.getTestName()));
    }

    @Test(description="See OGC 12-128r13: Requirement 29")
    public void featureTableIntegerPrimaryKey() throws SQLException {
        for (String tableName : this.featureTableNames) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("PRAGMA table_info(%s);", tableName));){
                Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format("MissingTable", tableName));
            }
            this.checkPrimaryKey(tableName, this.getPrimaryKeyColumn(tableName));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirements 19, 20")
    public void featureGeometryEncodingTableBlob() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT table_name AS tn, column_name AS cn FROM gpkg_geometry_columns WHERE table_name IN (SELECT table_name FROM gpkg_contents WHERE data_type = 'features');");){
            Throwable throwable;
            Statement statement3;
            while (resultSet1.next()) {
                block66: {
                    String pkColumn;
                    String cn = resultSet1.getString("cn");
                    String tn = resultSet1.getString("tn");
                    try {
                        pkColumn = this.getPrimaryKeyColumn(tn);
                    }
                    catch (AssertionError exc) {
                        pkColumn = "rowid";
                    }
                    statement3 = this.databaseConnection.createStatement();
                    throwable = null;
                    try (ResultSet resultSet3 = statement3.executeQuery(String.format("SELECT %s, %s FROM %s;", cn, pkColumn, tn));){
                        while (resultSet3.next()) {
                            int pk = resultSet3.getInt(pkColumn);
                            byte[] sgbpb = new byte[4];
                            try (InputStream sgpb = resultSet3.getBinaryStream(cn);){
                                sgpb.read(sgbpb);
                            }
                            catch (NullPointerException npe) {
                                continue;
                            }
                            catch (IOException e) {
                                Assert.assertTrue((boolean)false, (String)ErrorMessage.format("FeaturesBinaryInvalid", tn, pk, "Couldn't read WKB prefix"));
                            }
                            byte[] gp = Arrays.copyOfRange(sgbpb, 0, 2);
                            Assert.assertTrue((boolean)Arrays.equals(gp, GPKG12.BINARY_GP), (String)ErrorMessage.format("FeaturesBinaryInvalid", tn, pk, "First two bytes of WKB are wrong."));
                            Assert.assertTrue((sgbpb[2] == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("FeaturesBinaryInvalid", tn, pk, "Third byte of WKB must be 0."));
                            Assert.assertTrue(((sgbpb[3] & 0x20) == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("FeaturesBinaryInvalid", tn, pk, "Sixth bit of byte 4 of WKB must be 0."));
                            int envelope = (sgbpb[3] & 0xE) >> 1;
                            Assert.assertTrue((envelope <= 4 ? 1 : 0) != 0, (String)ErrorMessage.format("FeaturesBinaryInvalid", tn, pk, "Envelope type of WKB (byte 4) is invalid."));
                        }
                    }
                    if (statement3 == null) continue;
                    if (throwable == null) break block66;
                    try {
                        statement3.close();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        continue;
                    }
                }
                statement3.close();
            }
            return;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (statement3 == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            statement3.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                    statement3.close();
                    throw throwable4;
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 21")
    public void featureGeometryColumnsTableDef() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_geometry_columns');");){
            int passFlag = 0;
            int flagMask = 63;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("geometry_type_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("pk") == 0 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    passFlag |= 1;
                    continue;
                }
                if ("table_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("pk") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    passFlag |= 2;
                    continue;
                }
                if ("m".equals(name)) {
                    Assert.assertTrue((boolean)"TINYINT".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("pk") == 0 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    passFlag |= 4;
                    continue;
                }
                if ("z".equals(name)) {
                    Assert.assertTrue((boolean)"TINYINT".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("pk") == 0 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    passFlag |= 8;
                    continue;
                }
                if ("srs_id".equals(name)) {
                    Assert.assertTrue((boolean)"INTEGER".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue((resultSet.getInt("pk") == 0 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                    passFlag |= 0x10;
                    continue;
                }
                if (!"column_name".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)"FeaturesGeometryColumnsInvalid");
                Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                Assert.assertTrue((resultSet.getInt("pk") == 2 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
                passFlag |= 0x20;
            }
            Assert.assertTrue(((passFlag & 0x3F) == 63 ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsInvalid");
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 22")
    public void featureGeometryColumnsDataValues() throws SQLException {
        block48: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features';");){
                if (!resultSet.next()) break block48;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features' AND table_name NOT IN (SELECT table_name FROM gpkg_geometry_columns);");){
                    Assert.assertTrue((!resultSet2.next() ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsMismatch");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 23, 26")
    public void featureGeometryColumnsDataValuesTableName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_list('gpkg_geometry_columns');");){
            boolean foundContents = false;
            boolean foundSpatialRefSys = false;
            while (resultSet.next()) {
                String table = resultSet.getString("table");
                if ("gpkg_spatial_ref_sys".equals(table)) {
                    if (!"srs_id".equals(resultSet.getString("from")) || !"srs_id".equals(resultSet.getString("to"))) continue;
                    foundSpatialRefSys = true;
                    continue;
                }
                if (!"gpkg_contents".equals(table) || !"table_name".equals(resultSet.getString("from")) || !"table_name".equals(resultSet.getString("to"))) continue;
                foundContents = true;
            }
            Assert.assertTrue((foundContents && foundSpatialRefSys ? 1 : 0) != 0, (String)"FeaturesGeometryColumnsNoFK");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 24")
    public void featureGeometryColumnsDataValuesColumnName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name FROM gpkg_geometry_columns;");){
            while (resultSet.next()) {
                Statement statement2;
                block48: {
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
                            boolean foundMatch = false;
                            while (resultSet2.next()) {
                                if (!resultSet2.getString("name").equals(columnName)) continue;
                                foundMatch = true;
                                break;
                            }
                            Assert.assertTrue((boolean)foundMatch, (String)ErrorMessage.format("FeaturesGeometryColumnsInvalidCol", tableName, columnName));
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 25")
    public void featureGeometryColumnsDataValuesGeometryType() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns");){
            while (resultSet.next()) {
                String geometryTypeName = resultSet.getString("geometry_type_name");
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                boolean pass = false;
                if (this.getGeopackageVersion().equals((Object)CommonFixture.GeoPackageVersion.V120)) {
                    pass = ALLOWED_GEOMETRY_TYPES.contains(geometryTypeName);
                } else {
                    Iterator<String> iterator = ALLOWED_GEOMETRY_TYPES.iterator();
                    while (iterator.hasNext()) {
                        if (!geometryTypeName.equalsIgnoreCase(iterator.next())) continue;
                        pass = true;
                        break;
                    }
                }
                if (!pass) {
                    pass = this.isExtendedType(tableName, columnName);
                }
                Assert.assertTrue((boolean)pass, (String)ErrorMessage.format("FeaturesGeometryColumnsInvalidGeom", geometryTypeName, tableName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 27")
    public void featureGeometryColumnsDataValuesZ() throws SQLException {
        block49: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT z FROM gpkg_geometry_columns");){
                if (!resultSet.next()) break block49;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT z FROM gpkg_geometry_columns WHERE z NOT IN (0,1,2)");){
                    if (resultSet2.next()) {
                        Assert.assertTrue((boolean)false, (String)ErrorMessage.format("FeaturesGeometryColumnsInvalidZ", resultSet2.getInt("z")));
                    }
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 28")
    public void featureGeometryColumnsDataValuesM() throws SQLException {
        block49: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT m FROM gpkg_geometry_columns");){
                if (!resultSet.next()) break block49;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT m FROM gpkg_geometry_columns WHERE m NOT IN (0,1,2)");){
                    if (resultSet2.next()) {
                        Assert.assertTrue((boolean)false, (String)ErrorMessage.format("FeaturesGeometryColumnsInvalidM", resultSet2.getInt("m")));
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 30")
    public void featureTableOneGeometryColumn() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type='features'");){
            while (resultSet.next()) {
                Statement statement2;
                block47: {
                    String tableName = resultSet.getString("table_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT count(*) FROM gpkg_geometry_columns WHERE table_name = '%s'", tableName));){
                            resultSet2.next();
                            Assert.assertTrue((resultSet2.getInt(1) == 1 ? 1 : 0) != 0, (String)"FeaturesOneGeometryColumn");
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block47;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 31")
    public void featureTableGeometryColumnType() throws SQLException {
        if (!this.getGeopackageVersion().equals((Object)CommonFixture.GeoPackageVersion.V120)) return;
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns WHERE table_name IN (SELECT table_name FROM gpkg_contents WHERE data_type = 'features')");){
            while (resultSet.next()) {
                Statement statement2;
                block48: {
                    String geometryTypeName = resultSet.getString("geometry_type_name");
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info('%s')", tableName));){
                            while (resultSet2.next()) {
                                if (!columnName.equals(resultSet2.getString("name"))) continue;
                                Assert.assertTrue((boolean)geometryTypeName.equals(resultSet2.getString("type")), (String)"FeaturesGeometryColumnsMismatch");
                                break;
                            }
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    protected static Collection<String> getAllowedGeometryTypes() {
        return ALLOWED_GEOMETRY_TYPES;
    }
}

