/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.gpkg12.SuiteAttribute;
import org.opengis.cite.gpkg12.TestRunArg;
import org.opengis.cite.gpkg12.util.TestSuiteLogger;
import org.opengis.cite.gpkg12.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
    }

    public void onFinish(ISuite suite) {
        this.deleteTempFiles(suite);
    }

    void processSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = (String)params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File gpkgFile = null;
        try {
            gpkgFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", gpkgFile.getAbsolutePath(), gpkgFile.length()));
        suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), (Object)gpkgFile);
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
    }
}

