/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.attributes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AttributeTests
extends CommonFixture {
    private final Collection<String> attributeTableNames = new ArrayList<String>();

    @BeforeClass
    public void setUp() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'attributes'");){
            while (resultSet.next()) {
                this.attributeTableNames.add(resultSet.getString(1));
            }
        }
        Assert.assertTrue((!this.attributeTableNames.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassNotUsed", this.getTestName()));
    }

    @Test(description="See OGC 12-128r14: Requirement 119")
    public void attributeTableIntegerPrimaryKey() throws SQLException {
        for (String tableName : this.attributeTableNames) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("PRAGMA table_info(%s);", tableName));){
                Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format("MissingTable", tableName));
            }
            this.checkPrimaryKey(tableName, this.getPrimaryKeyColumn(tableName));
        }
    }
}

