/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.coverage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.tiles.TileTests;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TiledGriddedCoverageTests
extends TileTests {
    protected static final Collection<ImageReader> tiffImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/tiff"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    private boolean hasExtension = false;
    private final Collection<String> elevationTableNames = new ArrayList<String>();

    public TiledGriddedCoverageTests() {
        this.setDataType("2d-gridded-coverage");
    }

    @BeforeClass
    public void a_ValidateExtensionPresent(ITestContext testContext) throws SQLException {
        Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassNotUsed", "Coverage Extension"));
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT COUNT(*) FROM gpkg_extensions WHERE table_name = 'gpkg_2d_gridded_coverage_ancillary';");){
            resultSet1.next();
            Assert.assertTrue((resultSet1.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassNotUsed", "Coverage Extension"));
        }
    }

    @Override
    @BeforeClass
    public void setUp() throws SQLException {
        if (!this.hasExtension) {
            return;
        }
        try (Statement statement2 = this.databaseConnection.createStatement();
             ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = '2d-gridded-coverage';");){
            while (resultSet2.next()) {
                this.elevationTableNames.add(resultSet2.getString("table_name"));
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 1")
    public void coverageAncillaryTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_2d_gridded_coverage_ancillary');");){
            int passFlag = 0;
            int flagMask = 127;
            this.checkPrimaryKey("gpkg_2d_gridded_coverage_ancillary", "id");
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    passFlag |= 1;
                    continue;
                }
                if ("tile_matrix_set_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "tile_matrix_set_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "tile_matrix_set_name notnull"));
                    passFlag |= 2;
                    continue;
                }
                if ("datatype".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype notnull"));
                    String def = resultSet.getString("dflt_value");
                    Assert.assertTrue(("integer".equals(def) || "'integer'".equals(def) ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype default"));
                    passFlag |= 4;
                    continue;
                }
                if ("scale".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale notnull"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale default"));
                    passFlag |= 8;
                    continue;
                }
                if ("offset".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset notnull"));
                    Assert.assertTrue((resultSet.getFloat("dflt_value") == 0.0f ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset default"));
                    passFlag |= 0x10;
                    continue;
                }
                if ("precision".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision default"));
                    passFlag |= 0x20;
                    continue;
                }
                if (!"data_null".equals(name)) continue;
                Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "data_null type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "data_null notnull"));
                passFlag |= 0x40;
            }
            Assert.assertTrue(((passFlag & 0x7F) == 127 ? 1 : 0) != 0, (String)"CoverageAncillaryColumnsInvalid");
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 2")
    public void tileAncillaryTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_2d_gridded_tile_ancillary');");){
            long passFlag = 0L;
            long flagMask = 511L;
            while (resultSet.next()) {
                this.checkPrimaryKey("gpkg_2d_gridded_tile_ancillary", "id");
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    passFlag |= 1L;
                    continue;
                }
                if ("tpudt_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_name notnull"));
                    passFlag |= 2L;
                    continue;
                }
                if ("tpudt_id".equals(name)) {
                    Assert.assertTrue((boolean)"INTEGER".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_id type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_id notnull"));
                    passFlag |= 4L;
                    continue;
                }
                if ("scale".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale notnull"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale default"));
                    passFlag |= 8L;
                    continue;
                }
                if ("offset".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset notnull"));
                    Assert.assertTrue((resultSet.getFloat("dflt_value") == 0.0f ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset default"));
                    passFlag |= 0x10L;
                    continue;
                }
                if ("min".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "precision type"));
                    passFlag |= 0x20L;
                    continue;
                }
                if ("max".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "data_null type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "data_null notnull"));
                    passFlag |= 0x40L;
                    continue;
                }
                if ("mean".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "mean type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "mean type"));
                    passFlag |= 0x80L;
                    continue;
                }
                if (!"std_dev".equals(name)) continue;
                Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "std_dev type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "std_dev notnull"));
                passFlag |= 0x100L;
            }
            Assert.assertTrue(((passFlag & 0x1FFL) == 511L ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", String.format("Missing column flag %d", passFlag)));
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 3")
    public void requiredSRSRows() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefaultValue = statement.executeQuery("SELECT COUNT(*) FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4979 AND (organization = 'EPSG' OR organization = 'epsg');");){
            Assert.assertTrue((srsDefaultValue.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("NoElevationSrs", new Object[0]));
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 4, 5")
    public void requiredSRSReferences() throws SQLException {
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT srs_id FROM gpkg_tile_matrix_set WHERE table_name = '%s'", tableName));
                Throwable throwable2 = null;
                try {
                    resultSet1.next();
                    String srsID = resultSet1.getString(1);
                    Statement statement2 = this.databaseConnection.createStatement();
                    Throwable throwable3 = null;
                    try {
                        ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_spatial_ref_sys WHERE srs_id = '%s'", srsID));
                        Throwable throwable4 = null;
                        try {
                            Assert.assertTrue((resultSet2.getInt(1) == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("BadMatrixSetSrsReference", srsID));
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (resultSet2 == null) continue;
                            if (throwable4 != null) {
                                try {
                                    resultSet2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            resultSet2.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (statement2 == null) continue;
                        if (throwable3 != null) {
                            try {
                                statement2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        statement2.close();
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (resultSet1 == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet1.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    resultSet1.close();
                }
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (statement1 == null) continue;
                if (throwable != null) {
                    try {
                        statement1.close();
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                    }
                    continue;
                }
                statement1.close();
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 6")
    public void extensionTableRows() throws SQLException {
        Throwable throwable;
        try (Statement statement = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, extension_name, definition, scope from gpkg_extensions");){
                long passFlag = 0L;
                long flagMask = 3L;
                while (resultSet.next()) {
                    String name = resultSet.getString("table_name");
                    if ("gpkg_2d_gridded_coverage_ancillary".equals(name)) {
                        if (resultSet.getObject("column_name") != null || !"gpkg_2d_gridded_coverage".equals(resultSet.getString("extension_name")) || !"http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet.getString("definition")) || !"read-write".equals(resultSet.getString("scope"))) continue;
                        passFlag |= 1L;
                        continue;
                    }
                    if (!"gpkg_2d_gridded_tile_ancillary".equals(name) || resultSet.getObject("column_name") != null || !"gpkg_2d_gridded_coverage".equals(resultSet.getString("extension_name")) || !"http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet.getString("definition")) || !"read-write".equals(resultSet.getString("scope"))) continue;
                    passFlag |= 2L;
                }
                Assert.assertTrue(((passFlag & 3L) == 3L ? 1 : 0) != 0, (String)ErrorMessage.format("ElevationExtensionRowsMissing", String.format("Missing column flag %d", passFlag)));
            }
            catch (Throwable passFlag) {
                throwable = passFlag;
                throw passFlag;
            }
        }
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            throwable = null;
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT column_name, definition, scope from gpkg_extensions WHERE extension_name = 'gpkg_2d_gridded_coverage' AND table_name = '%s'", tableName));
                Throwable throwable2 = null;
                try {
                    Assert.assertTrue((resultSet1.next() && "tile_data".equals(resultSet1.getObject("column_name")) && "gpkg_2d_gridded_coverage".equals(resultSet1.getString("extension_name")) && "http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet1.getString("definition")) && "read-write".equals(resultSet1.getString("scope")) ? 1 : 0) != 0, (String)"ElevationExtensionRowsMissing");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet1 == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet1.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet1.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement1 == null) continue;
                if (throwable != null) {
                    try {
                        statement1.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement1.close();
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 7")
    public void coverageAncillaryValues() throws SQLException {
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '%s'", tableName));
                Throwable throwable2 = null;
                try {
                    resultSet1.next();
                    Assert.assertTrue((resultSet1.getInt(1) == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("MissingReference", "gpkg_2d_gridded_coverage_ancillary", "tile_matrix_set_name", tableName));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet1 == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet1.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet1.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement1 == null) continue;
                if (throwable != null) {
                    try {
                        statement1.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement1.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 17-066r1: Requirement 8")
    public void coverageAncillarySetName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT tile_matrix_set_name FROM 'gpkg_2d_gridded_coverage_ancillary';");){
            while (resultSet.next()) {
                Statement statement2;
                block47: {
                    String tileMatrixSetName = resultSet.getString(1);
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT count(*) FROM gpkg_tile_matrix_set WHERE table_name = '%s';", tileMatrixSetName));){
                            Assert.assertTrue((resultSet2.getInt(1) == 1 ? 1 : 0) != 0, (String)"UnreferencedCoverageTileMatrixSetTable");
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block47;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 9")
    public void coverageAncillaryDatatype() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT tile_matrix_set_name, datatype, scale, offset FROM 'gpkg_2d_gridded_coverage_ancillary';");){
            while (resultSet.next()) {
                String setName = resultSet.getString("tile_matrix_set_name");
                if (!this.elevationTableNames.contains(setName)) continue;
                String datatype = resultSet.getString("datatype");
                Assert.assertTrue(("integer".equals(datatype) || "float".equals(datatype) ? 1 : 0) != 0, (String)"CoverageAncillaryDatatypeInvalid");
                if (!"float".equals(datatype)) continue;
                double scale = resultSet.getDouble("scale");
                double offset = resultSet.getDouble("offset");
                Assert.assertTrue((scale == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_coverage_ancillary", "datatype", "float", "scale", "1.0", Double.toString(scale), "tile_matrix_set_name", setName));
                Assert.assertTrue((offset == 0.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_coverage_ancillary", "datatype", "float", "offset", "0.0", Double.toString(offset), "tile_matrix_set_name", setName));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 17-066r1: Requirements 10, 12")
    public void tileAncillaryTableRef() throws SQLException {
        Iterator<String> iterator = this.elevationTableNames.iterator();
        block35: while (iterator.hasNext()) {
            String tableName = iterator.next();
            Statement statement1 = this.databaseConnection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT id FROM %s", tableName));
                Throwable throwable2 = null;
                try {
                    Throwable throwable3;
                    Statement statement2;
                    while (true) {
                        block45: {
                            if (!resultSet1.next()) continue block35;
                            statement2 = this.databaseConnection.createStatement();
                            throwable3 = null;
                            try (ResultSet resultSet2 = statement2.executeQuery("SELECT %s.id as tid, gpkg_2d_gridded_tile_ancillary.tpudt_id as taid from %s LEFT OUTER JOIN gpkg_2d_gridded_tile_ancillary ON %s.id = gpkg_2d_gridded_tile_ancillary.tpudt_id AND gpkg_2d_gridded_tile_ancillary.tpudt_name = '%s'".replace("%s", tableName));){
                                while (resultSet2.next()) {
                                    String id = resultSet2.getString(1);
                                    resultSet2.getString(2);
                                    Assert.assertTrue((!resultSet2.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryReferences", tableName, id));
                                }
                            }
                            if (statement2 == null) continue;
                            if (throwable3 == null) break block45;
                            try {
                                statement2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        statement2.close();
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable3 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (statement2 == null) throw throwable6;
                            if (throwable3 != null) {
                                try {
                                    statement2.close();
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    throwable3.addSuppressed(throwable7);
                                    throw throwable6;
                                }
                            }
                            statement2.close();
                            throw throwable6;
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (resultSet1 == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet1.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    resultSet1.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (statement1 == null) continue;
                if (throwable != null) {
                    try {
                        statement1.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                statement1.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 17-066r1: Requirement 11")
    public void tileAncillaryTableVal() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT tpudt_name, scale, offset FROM gpkg_2d_gridded_tile_ancillary;");){
            while (resultSet1.next()) {
                Statement statement3;
                block73: {
                    Throwable throwable;
                    String tableName = resultSet1.getString("tpudt_name");
                    try (Statement statement2 = this.databaseConnection.createStatement();){
                        throwable = null;
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", tableName));){
                            Assert.assertTrue((boolean)resultSet2.next(), (String)ErrorMessage.format("TileAncillaryTableRefInvalid", tableName));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    statement3 = this.databaseConnection.createStatement();
                    var7_11 = null;
                    try {
                        throwable = null;
                        try (ResultSet resultSet3 = statement3.executeQuery(String.format("SELECT datatype from gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '%s'", tableName));){
                            Assert.assertTrue((boolean)resultSet3.next(), (String)ErrorMessage.format("TileAncillaryTableRefInvalid", tableName));
                            String datatype = resultSet3.getString("datatype");
                            if ("float".equals(datatype)) {
                                double scale = resultSet1.getDouble("scale");
                                double offset = resultSet1.getDouble("offset");
                                Assert.assertTrue((scale == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_tile_ancillary", "datatype", "float", "scale", "1.0", Double.toString(scale), "tpudt_name", tableName));
                                Assert.assertTrue((offset == 0.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_tile_ancillary", "datatype", "float", "offset", "0.0", Double.toString(offset), "tpudt_name", tableName));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        if (statement3 == null) continue;
                        if (var7_11 == null) break block73;
                    }
                    catch (Throwable throwable4) {
                        try {
                            var7_11 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (statement3 == null) throw throwable5;
                            if (var7_11 != null) {
                                try {
                                    statement3.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    var7_11.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                            statement3.close();
                            throw throwable5;
                        }
                    }
                    try {
                        statement3.close();
                        continue;
                    }
                    catch (Throwable throwable7) {
                        var7_11.addSuppressed(throwable7);
                        continue;
                    }
                }
                statement3.close();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Test(description="See OGC 12-128r12: Requirement 13/14")
    public void imageFormat() throws SQLException, IOException {
        Iterator<String> iterator = this.elevationTableNames.iterator();
        while (iterator.hasNext()) {
            String tableName = iterator.next();
            LinkedList<Integer> failedTileIds = new LinkedList<Integer>();
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT t.datatype AS datatype, u.id AS id, u.tile_data AS tile_data FROM gpkg_2d_gridded_coverage_ancillary t, %s u WHERE t.tile_matrix_set_name = '%s';".replace("%s", tableName));){
                while (resultSet.next()) {
                    MemoryCacheImageInputStream cacheImage;
                    block39: {
                        String datatype = resultSet.getString("datatype");
                        int id = resultSet.getInt("id");
                        cacheImage = new MemoryCacheImageInputStream(new ByteArrayInputStream(resultSet.getBytes("tile_data")));
                        Throwable throwable = null;
                        try {
                            if ("float".equals(datatype)) {
                                if (!TiledGriddedCoverageTests.canReadImage(tiffImageReaders, cacheImage)) {
                                    failedTileIds.add(id);
                                }
                            } else if ("integer".equals(datatype) && !TiledGriddedCoverageTests.canReadImage(pngImageReaders, cacheImage)) {
                                failedTileIds.add(id);
                            }
                            if (cacheImage == null) continue;
                            if (throwable == null) break block39;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (cacheImage == null) throw throwable3;
                                if (throwable == null) {
                                    cacheImage.close();
                                    throw throwable3;
                                }
                                try {
                                    cacheImage.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            cacheImage.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    cacheImage.close();
                }
            }
            Assert.assertTrue((boolean)failedTileIds.isEmpty(), (String)ErrorMessage.format("InvalidImageFormat", tableName, failedTileIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

