/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.webp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.tiles.TileTests;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class WebPTests
extends TileTests {
    protected static final Collection<ImageReader> webpImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/x-webp"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    private boolean hasExtension = false;

    @BeforeClass
    public void a_ValidateExtensionPresent(ITestContext testContext) throws SQLException {
        Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassNotUsed", "WebP Extension"));
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT COUNT(*) FROM gpkg_extensions WHERE extension_name = 'gpkg_webp';");){
            resultSet1.next();
            Assert.assertTrue((resultSet1.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassNotUsed", "WebP Extension"));
        }
        this.hasExtension = true;
    }

    @Override
    @BeforeClass
    public void setUp() throws SQLException {
        if (!this.hasExtension) {
            return;
        }
        try (Statement statement2 = this.databaseConnection.createStatement();
             ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_extensions WHERE extension_name = 'gpkg_webp';");){
            while (resultSet2.next()) {
                this.tileTableNames.add(resultSet2.getString("table_name"));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 91")
    public void coverageAncillaryTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, scope FROM gpkg_extensions where extension_name = 'gpkg_webp';");){
            while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                String scope = resultSet.getString("scope");
                Assert.assertTrue((boolean)"tile_data".equals(columnName), (String)ErrorMessage.format("IllegalValue", "gpkg_extensions", "extension_name", "gpkg_webp", "column_name", "tile_data", columnName, "table_name", tableName));
                Assert.assertTrue((boolean)"read-write".equals(scope), (String)ErrorMessage.format("IllegalValue", "gpkg_extensions", "extension_name", "gpkg_webp", "scope", "read-write", scope, "table_name", tableName));
            }
        }
    }

    @Override
    @Test(description="See OGC 12-128r13: Requirement 92")
    public void imageFormat() throws SQLException, IOException {
    }

    @Override
    protected boolean isAcceptedImageFormat(byte[] image) throws IOException {
        if (image == null) {
            return false;
        }
        ByteArrayInputStream byteArray = new ByteArrayInputStream(image);
        try (MemoryCacheImageInputStream cacheImage = new MemoryCacheImageInputStream(byteArray);){
            boolean bl = WebPTests.canReadImage(pngImageReaders, cacheImage) || WebPTests.canReadImage(jpegImageReaders, cacheImage) || WebPTests.canReadImage(webpImageReaders, cacheImage);
            return bl;
        }
    }
}

