/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.opengis.cite.gpkg12.ColumnDefinition;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public abstract class TileFixture
extends CommonFixture {
    private String dataType = "tiles";
    protected final Collection<String> tileTableNames = new ArrayList<String>();
    private static final double EPSILON = 1.0E-4;
    protected static final Collection<ImageReader> jpegImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/jpeg"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    protected static final Collection<ImageReader> pngImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/png"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    protected static final Map<String, ColumnDefinition> TileTableExpectedColumns = new HashMap<String, ColumnDefinition>();

    protected static boolean isEqual(double first, double second) {
        return Math.abs(first - second) < 1.0E-4;
    }

    @BeforeClass
    public void setUp() throws SQLException {
        String tableName2;
        Throwable throwable;
        Throwable throwable2;
        ArrayList<String> extensionTableNames = new ArrayList<String>();
        if (DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions")) {
            throwable2 = null;
            try (Statement statement2 = this.databaseConnection.createStatement();){
                throwable = null;
                try (ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_extensions WHERE column_name = 'tile_data';");){
                    while (resultSet2.next()) {
                        tableName2 = resultSet2.getString(1);
                        extensionTableNames.add(tableName2);
                    }
                }
                catch (Throwable tableName2) {
                    throwable = tableName2;
                    throw tableName2;
                }
            }
            catch (Throwable resultSet2) {
                throwable2 = resultSet2;
                throw resultSet2;
            }
        }
        throwable2 = null;
        try (Statement statement = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery(String.format("SELECT table_name FROM gpkg_contents WHERE data_type = '%s';", this.dataType));){
                while (resultSet.next()) {
                    tableName2 = resultSet.getString(1);
                    this.tileTableNames.add(tableName2);
                }
                this.tileTableNames.removeAll(extensionTableNames);
                Assert.assertTrue((!this.tileTableNames.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassNotUsed", this.getTestName()));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            throwable2 = throwable4;
            throw throwable4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean canReadImage(Iterable<ImageReader> imageReaders, ImageInputStream image) throws IOException {
        for (ImageReader imageReader : imageReaders) {
            try {
                image.mark();
                if (!imageReader.getOriginatingProvider().canDecodeInput(image)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                image.reset();
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected boolean isAcceptedImageFormat(byte[] image) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setDataType(String dataType) {
        this.dataType = dataType;
    }

    static {
        TileTableExpectedColumns.put("id", new ColumnDefinition("INTEGER", false, true, true, null));
        TileTableExpectedColumns.put("zoom_level", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_column", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_row", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_data", new ColumnDefinition("BLOB", true, false, false, null));
    }
}

