/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

public class ColumnDefinition {
    private final String sqlType;
    private final boolean notNull;
    private final boolean primaryKey;
    private final boolean unique;
    private final String defaultValue;

    public ColumnDefinition(String sqlType, boolean notNull, boolean primaryKey, boolean unique, String defaultValue) {
        if (sqlType == null) {
            throw new IllegalArgumentException("SQL type may not be null");
        }
        this.sqlType = sqlType;
        this.notNull = notNull;
        this.defaultValue = defaultValue;
        this.primaryKey = primaryKey;
        this.unique = primaryKey || unique;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColumnDefinition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ColumnDefinition other = (ColumnDefinition)object;
        boolean implicitNotNull = this.primaryKey && this.sqlType.toUpperCase().equals("INTEGER");
        return this.sqlType.equals(other.sqlType) && (this.notNull == other.notNull || implicitNotNull) && this.primaryKey == other.primaryKey && this.unique == other.unique;
    }

    public int hashCode() {
        return this.sqlType.hashCode() ^ (this.notNull ? 1 : 0) ^ (this.primaryKey ? 1 : 0) ^ (this.unique ? 1 : 0) ^ (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
    }

    public String toString() {
        return String.format("Type: %s, not null: %s, default value: %s, primary key: %s, unique: %s", this.sqlType, this.notNull, this.defaultValue, this.primaryKey, this.unique);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

