/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.SuiteAttribute;
import org.opengis.cite.gpkg12.TestRunArg;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;

public class CommonFixture {
    private final String ICS = "Core,Tiles,Features,Attributes,Extension Mechanism,Non-Linear Geometry Types,RTree Spatial Indexes,Tiles Encoding WebP,Metadata,Schema,WKT for Coordinate Reference Systems,Tiled Gridded Coverage Data";
    public static final String ROOT_PKG_PATH = "/org/opengis/cite/gpkg12/";
    protected File gpkgFile;
    protected DataSource dataSource;
    protected Connection databaseConnection;
    protected GeoPackageVersion geopackageVersion;
    private String testName;

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) throws SQLException, IOException {
        Object testFile = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testFile == null || !File.class.isInstance(testFile)) {
            throw new IllegalArgumentException(String.format("Suite attribute value is not a File: %s", SuiteAttribute.TEST_SUBJ_FILE.getName()));
        }
        this.geopackageVersion = (GeoPackageVersion)((Object)testContext.getSuite().getAttribute(SuiteAttribute.GPKG_VERSION.getName()));
        this.gpkgFile = (File)File.class.cast(testFile);
        this.gpkgFile.setWritable(false);
        SQLiteConfig dbConfig = new SQLiteConfig();
        dbConfig.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
        dbConfig.setJournalMode(SQLiteConfig.JournalMode.MEMORY);
        dbConfig.enforceForeignKeys(true);
        SQLiteDataSource sqliteSource = new SQLiteDataSource(dbConfig);
        sqliteSource.setUrl("jdbc:sqlite:" + this.gpkgFile.getPath());
        this.dataSource = sqliteSource;
        this.databaseConnection = this.dataSource.getConnection();
    }

    @AfterClass
    public void close() throws SQLException {
        if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
            this.databaseConnection.close();
        }
    }

    @BeforeTest
    public void validateClassEnabled(ITestContext testContext) throws IOException {
        Map params = testContext.getSuite().getXmlSuite().getParameters();
        String pstr = (String)params.get(TestRunArg.ICS.toString());
        String testName = testContext.getName();
        this.setTestName(testName);
        if (pstr == null || pstr.isEmpty()) {
            pstr = this.ICS;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(pstr.split(",")));
        Assert.assertTrue((boolean)set.contains(testName), (String)ErrorMessage.format("ConformanceClassDisabled", testName));
    }

    protected String getPrimaryKeyColumn(String tableName, boolean enforcePk) throws SQLException {
        String result = null;
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
            Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format("MissingTable", tableName));
            boolean pass = false;
            boolean first = true;
            String firstName = "";
            String firstType = "";
            do {
                int pk = resultSet.getInt("pk");
                String name = resultSet.getString("name");
                String type = resultSet.getString("type");
                if (first) {
                    firstName = name;
                    firstType = type;
                    first = false;
                }
                if (pk <= 0) continue;
                Assert.assertTrue((pk == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", tableName, String.format("%s has an invalid primary key value of %d", name, pk)));
                Assert.assertTrue((boolean)"INTEGER".equalsIgnoreCase(type), (String)ErrorMessage.format("InvalidDataType", name, tableName));
                result = name;
                pass = true;
            } while (resultSet.next());
            if (!enforcePk && !pass && "INTEGER".equalsIgnoreCase(firstType)) {
                result = firstName;
                pass = true;
            }
            Assert.assertTrue((pass && result != null ? 1 : 0) != 0, (String)ErrorMessage.format("TableNoPK", tableName));
        }
        return result;
    }

    protected boolean isExtendedType(String tableName, String columnName) throws SQLException {
        boolean result = false;
        if (DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions")) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_extensions WHERE table_name = '%s' AND column_name = '%s' AND extension_name LIKE 'gpkg_geom_%%'", tableName, columnName));){
                resultSet.next();
                result |= resultSet.getInt(1) > 0;
            }
        }
        return result;
    }

    protected void checkPrimaryKey(String tableName, String pkName, boolean enforcePk) throws SQLException {
        Throwable throwable;
        Throwable throwable2;
        if (pkName == null) {
            throw new IllegalArgumentException("pkName must not be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName must not be null.");
        }
        boolean pass = false;
        if (enforcePk) {
            throwable2 = null;
            try (Statement statement = this.databaseConnection.createStatement();){
                throwable = null;
                try (ResultSet resultSet = statement.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
                    Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format("MissingTable", tableName));
                    pass = false;
                    do {
                        int pk = resultSet.getInt("pk");
                        String name = resultSet.getString("name");
                        String type = resultSet.getString("type");
                        if (pk <= 0) continue;
                        Assert.assertTrue((pk == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", tableName, String.format("%s is a primary key of %d", name, pk)));
                        Assert.assertTrue((boolean)"INTEGER".equals(type), (String)ErrorMessage.format("InvalidDataType", name, tableName));
                        Assert.assertTrue((boolean)pkName.equals(name), (String)ErrorMessage.format("TableDefinitionInvalid", tableName, "pk " + name));
                        pass = true;
                    } while (resultSet.next());
                    Assert.assertTrue((boolean)pass, (String)ErrorMessage.format("TableNoPK", tableName));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable resultSet) {
                throwable2 = resultSet;
                throw resultSet;
            }
        }
        throwable2 = null;
        try (Statement statement2 = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT COUNT(distinct %s) - COUNT(*) from '%s'", pkName, tableName));){
                Assert.assertTrue((resultSet2.getInt(1) == 0 ? 1 : 0) != 0, (String)String.format("TablePKNotUnique", tableName));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            throwable2 = throwable5;
            throw throwable5;
        }
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }
}

