/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.opengis.cite.gpkg12.ColumnDefinition;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.ForeignKeyDefinition;
import org.opengis.cite.gpkg12.TableVerifier;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class DataContentsTests
extends CommonFixture {
    private static final Pattern TEXT_TYPE = Pattern.compile("TEXT\\([0-9]+\\)");
    private static final Pattern BLOB_TYPE = Pattern.compile("BLOB\\([0-9]+\\)");
    private static final Collection<String> ALLOWED_SQL_TYPES = Arrays.asList("BOOLEAN", "TINYINT", "SMALLINT", "MEDIUMINT", "INT", "FLOAT", "DOUBLE", "REAL", "TEXT", "BLOB", "DATE", "DATETIME", "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION", "INTEGER");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r14: Requirement 5")
    public void columnDataTypes() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents;");){
            Throwable throwable;
            Statement preparedStatement;
            while (resultSet.next()) {
                block48: {
                    String tableName = resultSet.getString("table_name");
                    if (!DatabaseUtility.doesTableOrViewExist(this.databaseConnection, tableName)) continue;
                    preparedStatement = this.databaseConnection.createStatement();
                    throwable = null;
                    try (ResultSet pragmaTableInfo = preparedStatement.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
                        while (pragmaTableInfo.next()) {
                            String dataType = pragmaTableInfo.getString("type");
                            String columnName = pragmaTableInfo.getString("name");
                            boolean correctDataType = this.isExtendedType(tableName, columnName) || DataContentsTests.getAllowedSqlTypes().contains(dataType) || TEXT_TYPE.matcher(dataType).matches() || BLOB_TYPE.matcher(dataType).matches();
                            Assert.assertTrue((boolean)correctDataType, (String)ErrorMessage.format("InvalidDataType", dataType, columnName, tableName));
                        }
                    }
                    if (preparedStatement == null) continue;
                    if (throwable == null) break block48;
                    try {
                        preparedStatement.close();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        continue;
                    }
                }
                preparedStatement.close();
            }
            return;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (preparedStatement == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                    preparedStatement.close();
                    throw throwable4;
                }
            }
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 13")
    public void contentsTableDefinition() throws SQLException {
        try {
            HashMap<String, ColumnDefinition> contentColumns = new HashMap<String, ColumnDefinition>();
            contentColumns.put("table_name", new ColumnDefinition("TEXT", true, true, true, null));
            contentColumns.put("data_type", new ColumnDefinition("TEXT", true, false, false, null));
            contentColumns.put("identifier", new ColumnDefinition("TEXT", false, false, true, null));
            contentColumns.put("description", new ColumnDefinition("TEXT", false, false, false, "''"));
            contentColumns.put("last_change", new ColumnDefinition("DATETIME", true, false, false, "strftime('%Y-%m-%dT%H:%M:%fZ', 'now')"));
            contentColumns.put("min_x", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("min_y", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("max_x", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("max_y", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("srs_id", new ColumnDefinition("INTEGER", false, false, false, null));
            TableVerifier.verifyTable(this.databaseConnection, "gpkg_contents", contentColumns, new HashSet<ForeignKeyDefinition>(Arrays.asList(new ForeignKeyDefinition("gpkg_spatial_ref_sys", "srs_id", "srs_id"))), Collections.emptyList());
        }
        catch (AssertionError ex) {
            AssertJUnit.fail((String)ErrorMessage.format("BadContentsTableDefinition", ((Throwable)((Object)ex)).getMessage()));
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 14")
    public void contentsTablesExist() throws SQLException {
        String query = "SELECT DISTINCT table_name FROM  gpkg_contents WHERE table_name NOT IN (SELECT name FROM sqlite_master);";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT DISTINCT table_name FROM  gpkg_contents WHERE table_name NOT IN (SELECT name FROM sqlite_master);");){
            LinkedList<String> invalidContentsTableNames = new LinkedList<String>();
            while (resultSet.next()) {
                invalidContentsTableNames.add(resultSet.getString(1));
            }
            Assert.assertTrue((boolean)invalidContentsTableNames.isEmpty(), (String)ErrorMessage.format("ContentTableDoesNotExist", String.join((CharSequence)", ", invalidContentsTableNames)));
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 15")
    public void timestampFormat() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT last_change, table_name FROM gpkg_contents;");){
            LinkedList<String> invalidDateTableNames = new LinkedList<String>();
            while (resultSet.next()) {
                String lastChange = resultSet.getString("last_change");
                try {
                    new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SS'Z'").parse(lastChange);
                }
                catch (ParseException ignore) {
                    invalidDateTableNames.add(resultSet.getString("table_name"));
                }
            }
            Assert.assertTrue((boolean)invalidDateTableNames.isEmpty(), (String)ErrorMessage.format("BadContentsEntryLastChangeFormat", String.join((CharSequence)", ", invalidDateTableNames)));
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 16")
    public void srsIdReferencesSrsTable() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_check('gpkg_contents');");){
            Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0, (String)ErrorMessage.format("BadContentsTableSrsForeignKey", new Object[0]));
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 17")
    public void optValidGeoPackage() throws SQLException {
    }

    public static Collection<String> getAllowedSqlTypes() {
        return ALLOWED_SQL_TYPES;
    }
}

