/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg12.ColumnDefinition;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.ForeignKeyDefinition;
import org.opengis.cite.gpkg12.TableVerifier;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MetadataTests
extends CommonFixture {
    private List<Metadata> metadataValues;
    private List<MetadataReference> metadataReferenceValues;

    @BeforeClass
    public void setUp() throws SQLException {
        Throwable throwable;
        ResultSet resultSet;
        this.metadataValues = new LinkedList<Metadata>();
        try (Statement statement = this.databaseConnection.createStatement();){
            resultSet = statement.executeQuery("SELECT md_scope, id FROM gpkg_metadata;");
            throwable = null;
            try {
                while (resultSet.next()) {
                    this.metadataValues.add(new Metadata(resultSet.getInt("id"), resultSet.getString("md_scope")));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        this.metadataReferenceValues = new LinkedList<MetadataReference>();
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            resultSet = statement.executeQuery("SELECT reference_scope, table_name, column_name, row_id_value, timestamp, md_file_id, md_parent_id FROM gpkg_metadata_reference;");
            throwable = null;
            try {
                while (resultSet.next()) {
                    this.metadataReferenceValues.add(new MetadataReference(resultSet.getString("reference_scope"), resultSet.getString("table_name"), resultSet.getString("column_name"), resultSet.getString("timestamp"), resultSet.getInt("md_file_id"), MetadataTests.nullSafeGet(resultSet, "row_id_value"), MetadataTests.nullSafeGet(resultSet, "md_parent_id")));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        if (this.geopackageVersion == GeoPackageVersion.V102) {
            Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_metadata"), (String)ErrorMessage.format("ConformanceClassDisabled", "Metadata Option"));
        } else {
            Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassDisabled", "Metadata Extension"));
            Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("MissingTable", "gpkg_extensions"));
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT count(*) from gpkg_extensions WHERE extension_name = 'gpkg_metadata';");){
                resultSet.next();
                Assert.assertTrue((resultSet.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassDisabled", "Metadata Extension"));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 93")
    public void metadataTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_metadata');");){
            int passFlag = 0;
            int flagMask = 31;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    Assert.assertTrue((boolean)"INTEGER".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "id type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "id notnull"));
                    Assert.assertTrue((resultSet.getInt("pk") > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "id pk"));
                    passFlag |= 1;
                    continue;
                }
                if ("md_scope".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "md_scope type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "md_scope notnull"));
                    String def = resultSet.getString("dflt_value");
                    Assert.assertTrue((def != null && def.contains("dataset") ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "md_scope default"));
                    passFlag |= 2;
                    continue;
                }
                if ("md_standard_uri".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "md_standard_uri type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "md_standard_uri notnull"));
                    passFlag |= 4;
                    continue;
                }
                if ("mime_type".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "mime_type type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "mime_type notnull"));
                    passFlag |= 8;
                    continue;
                }
                if (!"metadata".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "metadata type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "metadata notnull"));
                passFlag |= 0x10;
            }
            Assert.assertTrue(((passFlag & 0x1F) == 31 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata", "missing column(s)"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 94")
    public void metadataScopeValues() {
        List invalidScopeValues = this.metadataValues.stream().filter(Metadata::hasInvalidScope).map(Metadata::getMdScope).collect(Collectors.toList());
        Assert.assertTrue((boolean)invalidScopeValues.isEmpty(), (String)ErrorMessage.format("InvalidMetadataScope", String.join((CharSequence)", ", invalidScopeValues)));
    }

    @Test(description="See OGC 12-128r13: Requirement 95")
    public void metadataReferencesTableDefinition() {
        HashMap<String, ColumnDefinition> metadataReferenceTableColumns = new HashMap<String, ColumnDefinition>();
        metadataReferenceTableColumns.put("reference_scope", new ColumnDefinition("TEXT", true, false, false, null));
        metadataReferenceTableColumns.put("table_name", new ColumnDefinition("TEXT", false, false, false, null));
        metadataReferenceTableColumns.put("column_name", new ColumnDefinition("TEXT", false, false, false, null));
        metadataReferenceTableColumns.put("row_id_value", new ColumnDefinition("INTEGER", false, false, false, null));
        metadataReferenceTableColumns.put("timestamp", new ColumnDefinition("DATETIME", true, false, false, "strftime('%Y-%m-%dT%H:%M:%fZ', 'now')"));
        metadataReferenceTableColumns.put("md_file_id", new ColumnDefinition("INTEGER", true, false, false, null));
        metadataReferenceTableColumns.put("md_parent_id", new ColumnDefinition("INTEGER", false, false, false, null));
        try {
            TableVerifier.verifyTable(this.databaseConnection, "gpkg_metadata_reference", metadataReferenceTableColumns, new HashSet<ForeignKeyDefinition>(Arrays.asList(new ForeignKeyDefinition("gpkg_metadata", "md_parent_id", "id"), new ForeignKeyDefinition("gpkg_metadata", "md_file_id", "id"))), Collections.emptyList());
        }
        catch (Throwable th) {
            AssertJUnit.fail((String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_metadata_reference", th.getMessage()));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 140")
    public void metadataExtensionTableValues() throws SQLException {
        if (this.geopackageVersion == GeoPackageVersion.V102 || this.geopackageVersion == GeoPackageVersion.V110) {
            return;
        }
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT scope FROM gpkg_extensions WHERE extension_name = 'gpkg_metadata'");){
            while (resultSet.next()) {
                String scope = resultSet.getString("scope");
                Assert.assertTrue((boolean)"read-write".equals(scope), (String)ErrorMessage.format("InvalidExtensionDataScope", scope));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 96")
    public void metadataReferencesScopeValues() {
        Collection invalidScopeValues = this.metadataReferenceValues.stream().filter(MetadataReference::hasInvalidScope).map(MetadataReference::getReferenceScope).collect(Collectors.toList());
        Assert.assertTrue((boolean)invalidScopeValues.isEmpty(), (String)ErrorMessage.format("InvalidMetadataReferenceScope", String.join((CharSequence)", ", invalidScopeValues)));
    }

    @Test(description="See OGC 12-128r13: Requirement 97")
    public void metadataReferenceScopeAgreement() throws SQLException {
        List invalidGeoPackageValue = this.metadataReferenceValues.stream().filter(columnValue -> columnValue.getReferenceScope().equalsIgnoreCase("geopackage")).filter(columnValue -> columnValue.getColumnName() != null).collect(Collectors.toList());
        Assert.assertTrue((boolean)invalidGeoPackageValue.isEmpty(), (String)ErrorMessage.format("BadMetadataReferenceScopeColumnNameAgreement", invalidGeoPackageValue.stream().map(Object::toString).collect(Collectors.joining("\n"))));
        LinkedList<String> contentsTableNames = new LinkedList<String>();
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents;");){
            while (resultSet.next()) {
                contentsTableNames.add(resultSet.getString("table_name"));
            }
        }
        List badMetadataReferences = this.metadataReferenceValues.stream().filter(metadataReference -> !metadataReference.getReferenceScope().equalsIgnoreCase("geopackage")).filter(metadataReference -> !contentsTableNames.contains(metadataReference.getTableName())).collect(Collectors.toList());
        Assert.assertTrue((boolean)badMetadataReferences.isEmpty(), (String)ErrorMessage.format("InvalidMetadataReferenceTable", badMetadataReferences.stream().map(Object::toString).collect(Collectors.joining("\n"))));
    }

    private static Integer nullSafeGet(ResultSet resultSet, String columnLabel) throws SQLException {
        Integer value = resultSet.getInt(columnLabel);
        return resultSet.wasNull() ? null : value;
    }

    private static final class MetadataReference {
        private final String referenceScope;
        private static final Collection<String> validScopes = Arrays.asList("geopackage", "table", "column", "row", "row/col");
        private final String tableName;
        private final String columnName;
        private final Integer rowIdValue;
        private final String timestamp;
        private final int mdFileId;

        MetadataReference(String referenceScope, String tableName, String columnName, String timestamp, int mdFileId, Integer rowIdValue, Integer mdParentId) {
            this.referenceScope = referenceScope;
            this.tableName = tableName;
            this.columnName = columnName;
            this.rowIdValue = rowIdValue;
            this.timestamp = timestamp;
            this.mdFileId = mdFileId;
        }

        public String toString() {
            return String.format("scope: %s, table name: %s, column name: %s, timestamp: %s, metadata file identifier: %d, row identifier value: %d, metadata parent identifier: %d", this.referenceScope, this.tableName, this.columnName, this.timestamp, this.mdFileId, this.rowIdValue, this.mdFileId);
        }

        public String getReferenceScope() {
            return this.referenceScope;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean hasInvalidScope() {
            return !validScopes.contains(this.referenceScope.toLowerCase());
        }
    }

    private static final class Metadata {
        private final String mdScope;
        private static final Collection<String> validScopes = Arrays.asList("undefined", "fieldsession", "collectionsession", "series", "dataset", "featuretype", "feature", "attributetype", "attribute", "tile", "model", "catalog", "schema", "taxonomy", "software", "service", "collectionhardware", "nongeographicdataset", "dimensiongroup");

        Metadata(int id, String mdScope) {
            this.mdScope = mdScope;
        }

        public String getMdScope() {
            return this.mdScope;
        }

        public boolean hasInvalidScope() {
            return !validScopes.contains(this.mdScope.toLowerCase());
        }
    }
}

