/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.relatedtables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.extensions.relatedtables.RTEBase;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SimpleAttributesTests
extends RTEBase {
    @Override
    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        super.activeExtension(testContext);
        this.testRequirementsClassActive("simple_attributes", "Simple Attributes");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 18-000: Requirement 15")
    public void attributesTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT related_table_name FROM gpkgext_relations WHERE relation_name = 'simple_attributes';");){
            Throwable throwable;
            Statement statement2;
            while (resultSet.next()) {
                block54: {
                    String simpleAttributesTableName = resultSet.getString("related_table_name");
                    this.getPrimaryKeyColumn(simpleAttributesTableName, true);
                    statement2 = this.databaseConnection.createStatement();
                    throwable = null;
                    try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", simpleAttributesTableName));){
                        while (resultSet2.next()) {
                            String type = resultSet2.getString("type");
                            String name = resultSet2.getString("name");
                            switch (type) {
                                case "BLOB": {
                                    Assert.fail((String)ErrorMessage.format("InvalidDataType", type, name, simpleAttributesTableName));
                                    break;
                                }
                            }
                            int notNull = resultSet2.getInt("notnull");
                            Assert.assertEquals((int)notNull, (int)1, (String)ErrorMessage.format("InvalidColumnDefinition", name, simpleAttributesTableName, "notnull", 1, notNull));
                        }
                    }
                    if (statement2 == null) continue;
                    if (throwable == null) break block54;
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (statement2 == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            statement2.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                    statement2.close();
                    throw throwable4;
                }
            }
        }
    }
}

