/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.schema;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SchemaTests
extends CommonFixture {
    private static List<String> AllowedConstraintTypes = Arrays.asList("range", "enum", "glob");
    private String maxIsInclusive;
    private String minIsInclusive;

    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        if (this.geopackageVersion == GeoPackageVersion.V102) {
            Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_data_columns"), (String)ErrorMessage.format("ConformanceClassDisabled", "Schema Option"));
            this.minIsInclusive = "minIsInclusive";
            this.maxIsInclusive = "maxIsInclusive";
        } else {
            Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassDisabled", "Schema Extension"));
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT count(*) from gpkg_extensions WHERE extension_name = 'gpkg_schema';");){
                resultSet.next();
                Assert.assertTrue((resultSet.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassDisabled", "Schema Extension"));
            }
            this.minIsInclusive = "min_is_inclusive";
            this.maxIsInclusive = "max_is_inclusive";
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 103")
    public void dataColumnsTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_data_columns');");){
            int passFlag = 0;
            int flagMask = 127;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("table_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "table_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "table_name notnull"));
                    Assert.assertTrue((resultSet.getInt("pk") > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "table_name pk"));
                    passFlag |= 1;
                    continue;
                }
                if ("column_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "column_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "column_name notnull"));
                    Assert.assertTrue((resultSet.getInt("pk") > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "column_name pk"));
                    passFlag |= 2;
                    continue;
                }
                if ("name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "name notnull"));
                    passFlag |= 4;
                    continue;
                }
                if ("title".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "title type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "title notnull"));
                    passFlag |= 8;
                    continue;
                }
                if ("description".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "description type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "description notnull"));
                    passFlag |= 0x10;
                    continue;
                }
                if ("mime_type".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "mime_type type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "mime_type notnull"));
                    passFlag |= 0x20;
                    continue;
                }
                if (!"constraint_name".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "constraint_name type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "constraint_name notnull"));
                passFlag |= 0x40;
            }
            Assert.assertTrue(((passFlag & 0x7F) == 127 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_columns", "missing column(s)"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 104")
    public void dataColumnsTableName() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT DISTINCT gdc.table_name AS gdc_table, gc.table_name AS gc_table FROM gpkg_data_columns AS gdc LEFT OUTER JOIN gpkg_contents AS gc ON gdc.table_name = gc.table_name;");){
            while (resultSet1.next()) {
                String gcTable = resultSet1.getString("gc_table");
                String gdcTable = resultSet1.getString("gdc_table");
                Assert.assertTrue((gcTable != null ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidDataTable", "gpkg_data_columns", gdcTable));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 105")
    public void dataColumnsColumnName() throws SQLException {
        block38: {
            try (Statement statement1 = this.databaseConnection.createStatement();){
                ResultSet resultSet1 = statement1.executeQuery("SELECT table_name, column_name FROM gpkg_data_columns;");
                Throwable throwable = null;
                block29: while (true) {
                    try {
                        while (resultSet1.next()) {
                            String columnName = resultSet1.getString("column_name");
                            String tableName = resultSet1.getString("table_name");
                            try {
                                Statement statement2 = this.databaseConnection.createStatement();
                                Throwable throwable2 = null;
                                try {
                                    statement2.executeQuery(String.format("SELECT COUNT(%s) from %s;", columnName, tableName));
                                    continue block29;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (statement2 == null) continue block29;
                                    if (throwable2 != null) {
                                        try {
                                            statement2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block29;
                                    }
                                    statement2.close();
                                    continue block29;
                                }
                            }
                            catch (SQLException exc) {
                                Assert.fail((String)ErrorMessage.format("InvalidDataColumn", "gpkg_extensions", columnName, tableName));
                            }
                        }
                        break block38;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (resultSet1 != null) {
                        if (throwable != null) {
                            try {
                                resultSet1.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet1.close();
                        }
                    }
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 107")
    public void dataColumnConstraintsTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_data_column_constraints');");){
            int passFlag = 0;
            int flagMask = 255;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("constraint_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "constraint_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "constraint_name notnull"));
                    passFlag |= 1;
                    continue;
                }
                if ("constraint_type".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "constraint_type type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "constraint_type notnull"));
                    passFlag |= 2;
                    continue;
                }
                if ("value".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "value type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "value notnull"));
                    passFlag |= 4;
                    continue;
                }
                if ("min".equals(name)) {
                    Assert.assertTrue((boolean)"NUMERIC".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "min type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "min notnull"));
                    passFlag |= 8;
                    continue;
                }
                if (this.minIsInclusive.equalsIgnoreCase(name)) {
                    Assert.assertTrue((boolean)"BOOLEAN".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", this.minIsInclusive + " type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", this.minIsInclusive + " notnull"));
                    passFlag |= 0x10;
                    continue;
                }
                if ("max".equals(name)) {
                    Assert.assertTrue((boolean)"NUMERIC".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "max type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "max notnull"));
                    passFlag |= 0x20;
                    continue;
                }
                if (this.maxIsInclusive.equalsIgnoreCase(name)) {
                    Assert.assertTrue((boolean)"BOOLEAN".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", this.maxIsInclusive + " type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", this.maxIsInclusive + " notnull"));
                    passFlag |= 0x40;
                    continue;
                }
                if (!"description".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "description type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "description notnull"));
                passFlag |= 0x80;
            }
            Assert.assertTrue(((passFlag & 0xFF) == 255 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_data_column_constraints", "missing column(s)"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 108")
    public void dataColumnConstraintsType() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT DISTINCT constraint_type FROM gpkg_data_column_constraints");){
            while (resultSet1.next()) {
                String constraintType = resultSet1.getString("constraint_type");
                Assert.assertTrue((boolean)AllowedConstraintTypes.contains(constraintType), (String)ErrorMessage.format("UnexpectedValue", constraintType, "constraint_type", "gpkg_data_column_constraints"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 109")
    public void dataColumnConstraintsName() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT DISTINCT constraint_name FROM gpkg_data_column_constraints WHERE constraint_type IN ('range', 'glob')");){
            while (resultSet1.next()) {
                Statement statement2;
                block47: {
                    String constraintName = resultSet1.getString("constraint_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_data_column_constraints WHERE constraint_name = '%s'", constraintName));){
                            Assert.assertTrue((resultSet2.getInt(1) <= 1 ? 1 : 0) != 0, (String)ErrorMessage.format("NonUniqueValue", "constraint_name", "gpkg_data_column_constraints", constraintName));
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block47;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 110")
    public void dataColumnConstraintsValue() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT constraint_name, value FROM gpkg_data_column_constraints WHERE constraint_type = 'range'");){
            while (resultSet1.next()) {
                String constraintName = resultSet1.getString("constraint_name");
                String value = resultSet1.getString("value");
                Assert.assertTrue((value == null ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintNonNullValue", constraintName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 111")
    public void dataColumnConstraintsMinMax() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT constraint_name, min, max FROM gpkg_data_column_constraints WHERE constraint_type = 'range'");){
            while (resultSet1.next()) {
                String constraintName = resultSet1.getString("constraint_name");
                double min = resultSet1.getDouble("min");
                Assert.assertTrue((!resultSet1.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintMinMaxInvalid", constraintName));
                double max = resultSet1.getDouble("max");
                Assert.assertTrue((!resultSet1.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintMinMaxInvalid", constraintName));
                Assert.assertTrue((min <= max ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintMinMaxInvalid", constraintName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 112")
    public void dataColumnConstraintsInclusive() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT constraint_name, %s, %s FROM gpkg_data_column_constraints WHERE constraint_type = 'range'", this.minIsInclusive, this.maxIsInclusive));){
            while (resultSet1.next()) {
                String constraintName = resultSet1.getString("constraint_name");
                resultSet1.getBoolean(this.minIsInclusive);
                Assert.assertTrue((!resultSet1.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintInclusiveInvalid", constraintName));
                resultSet1.getBoolean(this.maxIsInclusive);
                Assert.assertTrue((!resultSet1.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintInclusiveInvalid", constraintName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 113")
    public void dataColumnConstraintsGlobMinMax() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT constraint_name, min, max, %s, %s FROM gpkg_data_column_constraints WHERE constraint_type IN ('enum','glob')", this.minIsInclusive, this.maxIsInclusive));){
            while (resultSet1.next()) {
                String constraintName = resultSet1.getString("constraint_name");
                resultSet1.getDouble("min");
                Assert.assertTrue((boolean)resultSet1.wasNull(), (String)ErrorMessage.format("ConstraintMinMaxInvalid", constraintName));
                resultSet1.getDouble("max");
                Assert.assertTrue((boolean)resultSet1.wasNull(), (String)ErrorMessage.format("ConstraintMinMaxInvalid", constraintName));
                resultSet1.getDouble(this.minIsInclusive);
                Assert.assertTrue((boolean)resultSet1.wasNull(), (String)ErrorMessage.format("ConstraintInclusiveInvalid", constraintName));
                resultSet1.getDouble(this.maxIsInclusive);
                Assert.assertTrue((boolean)resultSet1.wasNull(), (String)ErrorMessage.format("ConstraintInclusiveInvalid", constraintName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 114")
    public void dataColumnConstraintsGlobValue() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT constraint_name, value FROM gpkg_data_column_constraints WHERE constraint_type IN ('enum','glob')");){
            while (resultSet1.next()) {
                String constraintName = resultSet1.getString("constraint_name");
                resultSet1.getString("value");
                Assert.assertTrue((!resultSet1.wasNull() ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintNonNullValue", constraintName, "not"));
            }
        }
    }
}

