/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.opengis.cite.gpkg12.GPKG12;
import org.opengis.cite.gpkg12.SuiteAttribute;
import org.opengis.cite.gpkg12.util.GeoPackageUtils;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class VersionTests {
    private File gpkgFile;
    private GeoPackageVersion geopackageVersion;

    @BeforeClass
    public void initGeoPackageFile(ITestContext testContext) {
        Object testFile = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testFile == null || !File.class.isInstance(testFile)) {
            throw new IllegalArgumentException(String.format("Suite attribute value is not a File: %s", SuiteAttribute.TEST_SUBJ_FILE.getName()));
        }
        this.gpkgFile = (File)File.class.cast(testFile);
        this.gpkgFile.setWritable(false);
    }

    @AfterClass
    public void storeVersionInTestContext(ITestContext testContext) {
        testContext.getSuite().setAttribute(SuiteAttribute.GPKG_VERSION.getName(), (Object)this.geopackageVersion);
    }

    @Test(description="See OGC 12-128r12: Requirement 2")
    public void geopackageVersion() throws IOException {
        byte[] appID = GeoPackageUtils.getAppId(this.gpkgFile);
        if (Arrays.equals(appID, GPKG12.APP_GP10)) {
            this.geopackageVersion = GeoPackageVersion.V102;
        } else if (Arrays.equals(appID, GPKG12.APP_GP11)) {
            this.geopackageVersion = GeoPackageVersion.V110;
        } else if (Arrays.equals(appID, GPKG12.APP_GPKG)) {
            this.geopackageVersion = GeoPackageVersion.V120;
        }
    }
}

