/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.crswkt;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CRSWKT
extends CommonFixture {
    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassDisabled", "CRS WKT Extension"));
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT count(*) from gpkg_extensions WHERE extension_name = 'gpkg_crs_wkt';");){
            resultSet.next();
            Assert.assertTrue((resultSet.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassDisabled", "CRS WKT Extension"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 115")
    public void tableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_spatial_ref_sys');");){
            boolean passFlag = false;
            boolean flagMask = true;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if (!"definition_12_063".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_spatial_ref_sys", "definition_12_063 type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_spatial_ref_sys", "definition_12_063 notnull"));
                Assert.assertTrue((resultSet.getInt("pk") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_spatial_ref_sys", "definition_12_063 pk"));
                passFlag |= true;
            }
            Assert.assertTrue((passFlag & true ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkg_spatial_ref_sys", "missing column(s)"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 117")
    public void crsTableValues() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT srs_id, definition, definition_12_063 FROM gpkg_spatial_ref_sys WHERE srs_id NOT IN (0, -1);");){
            while (resultSet.next()) {
                Assert.assertTrue((!"undefined".equals(resultSet.getString("definition")) || !"undefined".equals(resultSet.getString("definition_12_063")) ? 1 : 0) != 0, (String)ErrorMessage.format("UndefinedSrs", resultSet.getString("srs_id")));
            }
        }
    }
}

