/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.Engine;
import com.occamlab.te.Generator;
import com.occamlab.te.RuntimeOptions;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TECore;
import com.occamlab.te.ViewLog;
import com.occamlab.te.index.Index;
import com.occamlab.te.util.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Test {
    private static final Logger LOGR = Logger.getLogger(Test.class.getName());
    public static final int TEST_MODE = 0;
    public static final int RETEST_MODE = 1;
    public static final int RESUME_MODE = 2;
    public static final int REDO_FROM_CACHE_MODE = 3;
    public static final int DOC_MODE = 4;
    public static final int CHECK_MODE = 5;
    public static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    public static final String TE_NS = "http://www.occamlab.com/te";
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    public static final String CTLP_NS = "http://www.occamlab.com/te/parsers";
    SetupOptions setupOpts = new SetupOptions();
    RuntimeOptions runOpts = new RuntimeOptions();

    void setRuntimeOptions(RuntimeOptions runOpts) {
        this.runOpts = runOpts;
    }

    private void executeTest(String relativePathToMainCtl) throws Exception {
        String[] arguments = new String[]{"-source=" + relativePathToMainCtl};
        this.execute(arguments);
    }

    public static void main(String[] args) throws Exception {
        Test test = new Test();
        test.execute(args);
    }

    public void execute(String[] args) throws Exception {
        boolean hasCache;
        File workDir = this.setupOpts.getWorkDir();
        boolean rslt = this.runOpts.setWorkDir(workDir);
        String cmd = "java com.occamlab.te.Test";
        File logDir = this.runOpts.getLogDir();
        String session = null;
        boolean hasSessionArg = false;
        int mode = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-cmd=")) {
                cmd = arg.substring(5);
                continue;
            }
            if (arg.equals("-h") || arg.equals("-help") || arg.equals("-?")) {
                Test.syntax(cmd);
                return;
            }
            if (arg.startsWith("-source=")) {
                String sourcePath = arg.substring(8);
                File sourceFile = new File(sourcePath);
                if (!sourceFile.isAbsolute()) {
                    File scriptsDir = new File(SetupOptions.getBaseConfigDirectory(), "scripts");
                    sourceFile = new File(scriptsDir, sourcePath);
                }
                if (sourceFile.exists() && this.setupOpts.addSourceWithValidation(sourceFile)) continue;
                System.out.println("Error: Cannot find CTL script(s) at " + sourceFile.getAbsolutePath());
                return;
            }
            if (args[i].startsWith("-logdir=")) {
                String path = args[i].substring(8);
                File file = new File(path);
                logDir = file.isAbsolute() ? file : new File(SetupOptions.getBaseConfigDirectory(), path);
                if (logDir.exists() && this.runOpts.setLogDir(logDir)) continue;
                System.out.println("Error: Cannot use logdir " + logDir.getAbsolutePath());
                return;
            }
            if (arg.startsWith("-session=")) {
                hasSessionArg = true;
                session = arg.substring(9);
                continue;
            }
            if (arg.startsWith("-base=")) {
                rslt = this.runOpts.setBaseURI(arg.substring(6));
                continue;
            }
            if (arg.startsWith("-test=")) {
                rslt = this.runOpts.setTestName(arg.substring(6));
                continue;
            }
            if (arg.startsWith("-suite=")) {
                rslt = this.runOpts.setSuiteName(arg.substring(7));
                continue;
            }
            if (arg.startsWith("-profile=")) {
                rslt = this.runOpts.addProfile(arg.substring(9));
                continue;
            }
            if (arg.startsWith("@")) {
                rslt = this.runOpts.addParam(arg.substring(1));
                continue;
            }
            if (arg.equals("-mode=test")) {
                mode = 0;
                continue;
            }
            if (arg.equals("-mode=retest")) {
                mode = 1;
                continue;
            }
            if (arg.equals("-mode=resume")) {
                mode = 2;
                continue;
            }
            if (arg.equals("-mode=doc")) {
                mode = 4;
                continue;
            }
            if (arg.equals("-mode=check")) {
                mode = 5;
                continue;
            }
            if (arg.equals("-mode=cache")) {
                mode = 3;
                continue;
            }
            if (arg.startsWith("-mode=")) {
                System.out.println("Error: Invalid mode.");
                return;
            }
            if (arg.equals("-validate=no")) {
                this.setupOpts.setValidate(false);
                continue;
            }
            if (arg.startsWith("-form=")) {
                rslt = this.runOpts.addRecordedForm(arg.substring(6));
                continue;
            }
            if (!arg.startsWith("-")) {
                if (mode == 1 || mode == 3) {
                    if (hasSessionArg) {
                        if (arg.startsWith(session)) {
                            rslt = this.runOpts.addTestPath(arg);
                            continue;
                        }
                        rslt = this.runOpts.addTestPath(session + "/" + arg);
                        continue;
                    }
                    int slash = arg.indexOf("/");
                    if (slash < 0) continue;
                    if (session == null) {
                        session = arg.substring(0, slash);
                    } else if (!arg.substring(0, slash).equals(session)) {
                        System.out.println("Each test path must be within the same session.");
                        return;
                    }
                    rslt = this.runOpts.addTestPath(arg);
                    continue;
                }
                System.out.println("Unrecognized parameter \"" + arg + "\"");
                continue;
            }
            System.out.println("Unrecognized parameter \"" + arg + "\"");
        }
        rslt = this.runOpts.setMode(mode);
        rslt = this.runOpts.setSessionId(session);
        if (mode == 1 || mode == 2 || mode == 3) {
            if (logDir == null || session == null) {
                Test.syntax(cmd);
                return;
            }
            if (this.setupOpts.getSources().isEmpty()) {
                this.loadSources();
            }
        }
        if (this.setupOpts.getSources().isEmpty()) {
            System.out.println("Error: At least one -source parameter is required");
            return;
        }
        if (this.runOpts.getProfiles().size() > 0 && logDir == null) {
            System.out.println("Error: A -logdir parameter is required for testing profiles");
            return;
        }
        if (session == null) {
            session = System.getProperty("team.session");
        }
        if (session == null) {
            session = logDir == null ? "s0001" : LogUtils.generateSessionId(logDir);
            rslt = this.runOpts.setSessionId(session);
        }
        Thread.currentThread().setName("TEAM Engine");
        Index masterIndex = new Index();
        File indexFile = null;
        if (logDir != null && session != null) {
            File dir2 = new File(logDir, this.runOpts.getSessionId());
            indexFile = new File(dir2, "index.xml");
        }
        boolean regenerate = false;
        if (mode == 0 || mode == 5) {
            regenerate = true;
        } else if (mode == 4) {
            masterIndex = Generator.generateDocXsl(this.setupOpts);
        } else if (indexFile == null || !indexFile.canRead()) {
            System.out.println("Error: Can't read index file.");
            regenerate = true;
        } else {
            masterIndex = new Index(indexFile);
            if (masterIndex.outOfDate()) {
                System.out.println("Warning: Scripts have changed since this session was first executed.");
                if (mode == 3) {
                    System.out.println("Regenerating masterIndex from source scripts");
                    regenerate = true;
                }
            }
        }
        if (regenerate) {
            masterIndex = Generator.generateXsl(this.setupOpts);
            if (indexFile != null) {
                masterIndex.persist(indexFile);
            }
        }
        if (mode == 3 && !(hasCache = ViewLog.checkCache(logDir, session))) {
            File dir3 = new File(logDir, this.runOpts.getSessionId());
            throw new Exception("Error: no cache for " + dir3.getAbsolutePath());
        }
        if (masterIndex != null) {
            masterIndex.setElements(null);
        } else {
            masterIndex = new Index();
        }
        ArrayList<File> resourcesDirs = new ArrayList<File>();
        for (File sourceFile : this.setupOpts.getSources()) {
            File resourcesDir = Test.findResourcesDirectory(sourceFile);
            if (resourcesDirs.contains(resourcesDir)) continue;
            resourcesDirs.add(resourcesDir);
        }
        TEClassLoader cl = new TEClassLoader(resourcesDirs);
        Engine engine = new Engine(masterIndex, this.setupOpts.getSourcesName(), cl);
        if (this.setupOpts.isPreload() || mode == 5) {
            engine.preload(masterIndex, this.setupOpts.getSourcesName());
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(this.runOpts.toString());
        }
        if (mode == 0) {
            this.saveSources();
        }
        if (mode != 5) {
            TECore core = new TECore(engine, masterIndex, this.runOpts);
            core.execute();
        }
    }

    static File findResourcesDirectory(File sourceFile) {
        File parent = sourceFile.getParentFile();
        if (null == parent) {
            return null;
        }
        File[] resourceDirs = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.equalsIgnoreCase("resources") && new File(dir2, name).isDirectory();
            }
        });
        if (resourceDirs.length > 0) {
            return resourceDirs[0];
        }
        return Test.findResourcesDirectory(parent);
    }

    static void syntax(String cmd) {
        System.out.println();
        System.out.println("Test mode:");
        System.out.println("  Use to start a test session.\n");
        System.out.println("  " + cmd + " [-mode=test] -source=ctlfile|dir ...");
        System.out.println("    [-logdir=dir] [-session=session] [-base=baseURI]");
        System.out.println("    -suite=qname [-profile=qname|*] ... | -test=qname [@param-name=value] ...\n");
        System.out.println("    qname=[namespace_uri,|prefix:]local_name\n");
        System.out.println("Resume mode:");
        System.out.println("  Use to resume a test session that was interrupted before completion.\n");
        System.out.println("  " + cmd + " -mode=resume [-logdir=dir] -session=session\n");
        System.out.println("Retest mode:");
        System.out.println("  Use to reexecute individual tests.\n");
        System.out.println("  " + cmd + " -mode=retest [-logdir=dir] testpath1 [testpath2] ...\n");
        System.out.println("Redo From Cache Mode:");
        System.out.println("  Use to rerun tests with cached server responses when the test has changed.\n");
        System.out.println("  " + cmd + "-mode=cache [-logdir=dir] [-session=session] [testpath1 [testpath2]]\n");
        System.out.println("  Warning: Test changes may make cached server responses invalid.\n");
        System.out.println("Check mode:");
        System.out.println("  Use to validate source files.\n");
        System.out.println("  " + cmd + " -mode=check -source=ctlfile|dir ...\n");
        System.out.println("Doc mode:");
        System.out.println("  Use to visit all subtests and generate log files without executing them.\n");
        System.out.println("  " + cmd + " -mode=doc -source=ctlfile|dir ... [-suite=qname]\n");
    }

    public static String getModeName(int mode) {
        switch (mode) {
            case 0: {
                return "Test Mode";
            }
            case 1: {
                return "Retest Mode";
            }
            case 2: {
                return "Resume Mode";
            }
            case 3: {
                return "Redo From Cache Mode";
            }
            case 4: {
                return "Doc Mode";
            }
            case 5: {
                return "Check Mode";
            }
        }
        return "Invalid Mode";
    }

    private void saveSources() {
        if (this.runOpts.getLogDir() != null && this.runOpts.getSessionId() != null) {
            File sessionDir = new File(this.runOpts.getLogDir(), this.runOpts.getSessionId());
            File sourcesFile = new File(sessionDir, "sources.xml");
            try (PrintWriter writer = new PrintWriter(sourcesFile);){
                writer.println("<sources>");
                for (File file : this.setupOpts.getSources()) {
                    writer.println("<source>" + file.getPath() + "</source>");
                }
                writer.println("</sources>");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadSources() {
        File sessionDir;
        File sourcesFile;
        if (this.runOpts.getLogDir() != null && this.runOpts.getSessionId() != null && (sourcesFile = new File(sessionDir = new File(this.runOpts.getLogDir(), this.runOpts.getSessionId()), "sources.xml")).exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setExpandEntityReferences(false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(sourcesFile);
                NodeList nl = doc.getElementsByTagName("source");
                for (int i = 0; i < nl.getLength(); ++i) {
                    String sourcePath = nl.item(i).getTextContent();
                    File sourceFile = new File(sourcePath);
                    this.setupOpts.addSourceWithValidation(sourceFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

