/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NumberFn
extends SystemFunction
implements ItemMappingFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault();
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodes);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item arg0 = this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return DoubleValue.NaN;
        }
        if (arg0 instanceof BooleanValue || arg0 instanceof NumericValue) {
            ConversionResult result = ((AtomicValue)arg0).convert(BuiltInAtomicType.DOUBLE, true, context);
            if (result instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (AtomicValue)result;
        }
        if (arg0 instanceof StringValue && !(arg0 instanceof AnyURIValue)) {
            CharSequence s2 = arg0.getStringValueCS();
            try {
                return new DoubleValue(Value.stringToNumber(s2));
            }
            catch (NumberFormatException e) {
                return DoubleValue.NaN;
            }
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue value) {
        try {
            if (value == null) {
                return DoubleValue.NaN;
            }
            if (value instanceof BooleanValue || value instanceof NumericValue) {
                ConversionResult result = value.convert(BuiltInAtomicType.DOUBLE, true, null);
                if (result instanceof ValidationFailure) {
                    return DoubleValue.NaN;
                }
                return (DoubleValue)result;
            }
            if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
                CharSequence s2 = value.getStringValueCS();
                return new DoubleValue(Value.stringToNumber(s2));
            }
            return DoubleValue.NaN;
        }
        catch (NumberFormatException e) {
            return DoubleValue.NaN;
        }
    }

    public Item map(Item item) throws XPathException {
        return NumberFn.convert((AtomicValue)item);
    }
}

