/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.List;
import java.util.function.Function;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Content;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.ContentAssembler;
import org.apache.jena.assembler.assemblers.PrefixMappingAssembler;
import org.apache.jena.assembler.exceptions.TransactionAbortedException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;

public abstract class ModelAssembler
extends AssemblerBase
implements Assembler {
    protected abstract Model openEmptyModel(Assembler var1, Resource var2, Mode var3);

    protected Model openModel(Assembler a, Resource root, Content initial, Mode mode) {
        Model m3 = this.openEmptyModel(a, root, mode);
        if (!initial.isEmpty()) {
            this.addContent(root, m3, initial);
        }
        return m3;
    }

    @Override
    public Object open(Assembler a, Resource root, Mode mode) {
        Model m3 = this.openModel(a, root, this.getInitialContent(a, root), mode);
        this.addContent(root, m3, this.getContent(a, root));
        m3.setNsPrefixes(this.getPrefixMapping(a, root));
        return m3;
    }

    protected void addContent(Resource root, Model m3, Content c) {
        if (m3.supportsTransactions()) {
            m3.begin();
            try {
                c.fill(m3);
                m3.commit();
            }
            catch (Throwable t) {
                m3.abort();
                throw new TransactionAbortedException(root, t);
            }
        } else {
            c.fill(m3);
        }
    }

    private PrefixMapping getPrefixMapping(Assembler a, Resource root) {
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    @Override
    public Model openModel(Resource root, Mode mode) {
        return (Model)this.open(this, root, mode);
    }

    protected Content getInitialContent(Assembler a, Resource root) {
        Model partial = ModelFactory.createDefaultModel();
        Resource combined = partial.createResource();
        StmtIterator it = root.listProperties(JA.initialContent);
        while (it.hasNext()) {
            this.transferContentProperties(partial, it.nextStatement().getResource(), combined);
        }
        return this.contentFromModel(a, root, partial, combined);
    }

    private Content contentFromModel(Assembler a, Resource root, Model partial, Resource combined) {
        return partial.isEmpty() ? Content.empty : (Content)a.open(this.completedClone(root, combined, partial));
    }

    protected Content getContent(Assembler a, Resource root) {
        Resource newRoot = this.oneLevelClone(root);
        Model fragment = newRoot.getModel();
        return fragment.isEmpty() ? Content.empty : (Content)a.open(a, this.completedClone(root, newRoot, fragment));
    }

    private Resource completedClone(Resource root, Resource newRoot, Model fragment) {
        Model typed = fragment.add(newRoot, RDF.type, JA.Content);
        return newRoot.inModel(ModelFactory.createUnion(root.getModel(), typed));
    }

    private Resource oneLevelClone(Resource root) {
        Model partialCopy = ModelFactory.createDefaultModel();
        Resource newRoot = partialCopy.createResource();
        this.transferContentProperties(partialCopy, root, newRoot);
        return newRoot;
    }

    private void transferContentProperties(Model partial, Resource someInitial, Resource combined) {
        for (Property contentProperty : ContentAssembler.contentProperties) {
            partial.add(this.copyProperties(someInitial, this.replaceSubjectMap(partial, combined), contentProperty));
        }
    }

    private List<Statement> copyProperties(Resource root, Function<Statement, Statement> replace, Property property) {
        return root.listProperties(property).mapWith(replace).toList();
    }

    private Function<Statement, Statement> replaceSubjectMap(Model inModel, Resource newSubject) {
        return s2 -> inModel.createStatement(newSubject, s2.getPredicate(), s2.getObject());
    }
}

