/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExtensionsTests
extends CommonFixture {
    @BeforeClass
    public void validateTableExists(ITestContext testContext) throws SQLException {
        Assert.assertTrue(DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), ErrorMessage.format("ConformanceClassDisabled", "Extensions"));
    }

    @Test(description="See OGC 12-128r13: Requirement 58")
    public void extensionsTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_extensions');");){
            int passFlag = 0;
            int flagMask = 31;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("table_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "table_name type"));
                    Assert.assertTrue(resultSet.getInt("notnull") == 0, ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "table_name notnull"));
                    passFlag |= 1;
                    continue;
                }
                if ("column_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "column_name type"));
                    Assert.assertTrue(resultSet.getInt("notnull") == 0, ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "column_name notnull"));
                    passFlag |= 2;
                    continue;
                }
                if ("extension_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "extension_name type"));
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "extension_name notnull"));
                    passFlag |= 4;
                    continue;
                }
                if ("definition".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), "definition type");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "definition notnull"));
                    passFlag |= 8;
                    continue;
                }
                if (!"scope".equals(name)) continue;
                Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "scope type"));
                Assert.assertTrue(resultSet.getInt("notnull") == 1, "scope notnull");
                passFlag |= 0x10;
            }
            Assert.assertTrue((passFlag & 0x1F) == 31, ErrorMessage.format("TableDefinitionInvalid", "gpkg_extensions", "missing column(s)"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 60")
    public void extensionsTableValues() throws SQLException {
        Throwable throwable;
        try (Statement statement = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet = statement.executeQuery("SELECT lower(table_name) AS table_name, column_name FROM gpkg_extensions;");){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    Assert.assertTrue(columnName == null || tableName != null, ErrorMessage.format("InvalidDataColumn", "gpkg_extensions", tableName, columnName));
                }
            }
            catch (Throwable tableName) {
                throwable = tableName;
                throw tableName;
            }
        }
        var2_2 = null;
        try (Statement statement2 = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet2 = statement2.executeQuery("SELECT DISTINCT lower(ge.table_name) AS ge_table, lower(sm.tbl_name) AS tbl_name FROM gpkg_extensions AS ge LEFT OUTER JOIN sqlite_master AS sm ON lower(ge.table_name) = lower(sm.tbl_name);");){
                while (resultSet2.next()) {
                    String geTable = resultSet2.getString("ge_table");
                    String tableName = resultSet2.getString("tbl_name");
                    Assert.assertTrue(geTable == null && tableName == null || tableName != null && tableName.equals(geTable), ErrorMessage.format("InvalidDataTable", "gpkg_extensions", geTable));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 61")
    public void extensionsColumnValues() throws SQLException {
        block38: {
            try (Statement statement = this.databaseConnection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT lower(table_name) AS table_name, lower(column_name) AS column_name FROM gpkg_extensions WHERE column_name IS NOT NULL;");
                Throwable throwable = null;
                block29: while (true) {
                    try {
                        while (resultSet.next()) {
                            String tableName = resultSet.getString("table_name");
                            String columnName = resultSet.getString("column_name");
                            try {
                                Statement statement1 = this.databaseConnection.createStatement();
                                Throwable throwable2 = null;
                                try {
                                    statement1.executeQuery(String.format("SELECT COUNT(%s) from %s;", columnName, tableName));
                                    continue block29;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (statement1 == null) continue block29;
                                    if (throwable2 != null) {
                                        try {
                                            statement1.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block29;
                                    }
                                    statement1.close();
                                    continue block29;
                                }
                            }
                            catch (SQLException exc) {
                                Assert.fail(ErrorMessage.format("InvalidDataColumn", "gpkg_extensions", columnName, tableName));
                            }
                        }
                        break block38;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 64")
    public void extensionsColumnScope() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT scope FROM gpkg_extensions;");){
            while (resultSet.next()) {
                String scope = resultSet.getString("scope");
                Assert.assertTrue("read-write".equals(scope) || "write-only".equals(scope), ErrorMessage.format("InvalidExtensionDataScope", scope));
            }
        }
    }
}

