/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.nonlinear;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.FeaturesFixture;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NonlinearTests
extends FeaturesFixture {
    private static final Collection<String> extendedGeometryTypes = Arrays.asList("CIRCULARSTRING", "COMPOUNDCURVE", "CURVEPOLYGON", "MULTICURVE", "MULTISURFACE", "CURVE", "SURFACE");

    @BeforeClass
    public void validateExtensionPresent(ITestContext testContext) throws SQLException {
        Assert.assertTrue(DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), ErrorMessage.format("ConformanceClassDisabled", "Non-Linear Geometry Types Extension"));
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT COUNT(*) FROM gpkg_extensions WHERE extension_name LIKE 'gpkg_geom_%';");){
            resultSet1.next();
            Assert.assertTrue(resultSet1.getInt(1) > 0, ErrorMessage.format("ConformanceClassDisabled", "Non-Linear Geometry Types Extension"));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 65")
    public void featureGeometryColumnsDataValuesGeometryType() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns");){
            while (resultSet.next()) {
                String geometryTypeName = resultSet.getString("geometry_type_name");
                String tableName = resultSet.getString("table_name");
                boolean pass = false;
                if (this.geopackageVersion.equals((Object)GeoPackageVersion.V120)) {
                    pass |= NonlinearTests.getAllowedGeometryTypes().contains(geometryTypeName) || extendedGeometryTypes.contains(geometryTypeName);
                } else {
                    for (String geometryType : extendedGeometryTypes) {
                        if (!geometryTypeName.equalsIgnoreCase(geometryType)) continue;
                        pass = true;
                        break;
                    }
                    for (String geometryType : NonlinearTests.getAllowedGeometryTypes()) {
                        if (!geometryTypeName.equalsIgnoreCase(geometryType)) continue;
                        pass = true;
                        break;
                    }
                }
                Assert.assertTrue(pass, ErrorMessage.format("FeaturesGeometryColumnsInvalidGeom", geometryTypeName, tableName));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 68")
    public void extensionsRow() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns");){
            while (resultSet1.next()) {
                Statement statement2;
                block48: {
                    String geometryTypeName = resultSet1.getString("geometry_type_name");
                    if (!extendedGeometryTypes.contains(geometryTypeName)) continue;
                    String tableName = resultSet1.getString("table_name");
                    String columnName = resultSet1.getString("column_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT extension_name FROM gpkg_extensions WHERE table_name = '%s' AND column_name = '%s'", tableName, columnName));){
                            boolean pass = false;
                            while (resultSet2.next()) {
                                if (!resultSet2.getString(1).equals(String.format("gpkg_geom_%s", geometryTypeName))) continue;
                                pass |= true;
                                break;
                            }
                            Assert.assertTrue(pass, ErrorMessage.format("ExtendedGeometryReferenceMissing", tableName, geometryTypeName));
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }
}

