/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.relatedtables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.extensions.relatedtables.RTEBase;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MediaTests
extends RTEBase {
    @Override
    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        super.activeExtension(testContext);
        this.testRequirementsClassActive("media", "Media");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 18-000: Requirement 12b, 13")
    public void mediaTableDefinition() throws SQLException {
        this.testRelatedType("media", "attributes");
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT related_table_name FROM gpkgext_relations WHERE relation_name = 'media';");){
            Throwable throwable;
            Statement statement2;
            while (resultSet.next()) {
                block49: {
                    int passFlag = 0;
                    int flagMask = 3;
                    String relatedTableName = resultSet.getString("related_table_name");
                    this.getPrimaryKeyColumn(relatedTableName, true);
                    statement2 = this.databaseConnection.createStatement();
                    throwable = null;
                    try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", relatedTableName));){
                        while (resultSet2.next()) {
                            String name = resultSet2.getString("name");
                            if ("data".equals(name)) {
                                Assert.assertEquals(resultSet2.getString("type"), "BLOB", ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "data type"));
                                Assert.assertEquals(resultSet2.getInt("notnull"), 1, ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "data notnull"));
                                Assert.assertEquals(resultSet2.getInt("pk"), 0, ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "data pk"));
                                passFlag |= 1;
                                continue;
                            }
                            if (!"content_type".equals(name)) continue;
                            Assert.assertEquals(resultSet2.getString("type"), "TEXT", ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "content_type type"));
                            Assert.assertEquals(resultSet2.getInt("notnull"), 1, ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "content_type notnull"));
                            Assert.assertEquals(resultSet2.getInt("pk"), 0, ErrorMessage.format("TableDefinitionInvalid", relatedTableName, "content_type pk"));
                            passFlag |= 2;
                        }
                        Assert.assertTrue((passFlag & 3) == 3, ErrorMessage.format("TableDefinitionInvalid", relatedTableName, String.format("missing column(s): code(%s)", passFlag)));
                    }
                    if (statement2 == null) continue;
                    if (throwable == null) break block49;
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (statement2 == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            statement2.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                    statement2.close();
                    throw throwable4;
                }
            }
        }
    }
}

