/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.relatedtables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;

public abstract class RTEBase
extends CommonFixture {
    @BeforeClass
    protected void activeExtension(ITestContext testContext) throws SQLException {
        Assert.assertTrue(DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), ErrorMessage.format("ConformanceClassNotUsed", "Related Tables Extension"));
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT count(*) from gpkg_extensions WHERE extension_name IN ('related_tables', 'gpkg_related_tables');");){
            resultSet.next();
            Assert.assertTrue(resultSet.getInt(1) > 0, ErrorMessage.format("ConformanceClassNotUsed", "Related Tables Extension"));
        }
    }

    protected void testRequirementsClassActive(String relationName, String className) throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT COUNT(*) FROM gpkgext_relations WHERE relation_name = '%s'", relationName));){
            resultSet.next();
            Assert.assertTrue(resultSet.getInt(1) > 0, ErrorMessage.format("ConformanceClassNotUsed", String.format("Related Tables Extension, %s Requirements Class", className)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void testRelatedType(String relationName, String requiredType) throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT related_table_name FROM gpkgext_relations WHERE relation_name = '%s';", relationName));){
            while (resultSet.next()) {
                Statement statement2;
                block47: {
                    String relatedTableName = resultSet.getString("related_table_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT data_type FROM gpkg_contents WHERE table_name = '%s';", relatedTableName));){
                            Assert.assertTrue(resultSet2.next(), ErrorMessage.format("MissingReference", "gpkg_contents", "table_name", relatedTableName));
                            String dataType = resultSet2.getString("data_type");
                            Assert.assertEquals(dataType, requiredType, ErrorMessage.format("InvalidDataType", dataType, relatedTableName, "gpkgext_relations"));
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block47;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }
}

