/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.rtreeindex;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RTreeIndexTests
extends CommonFixture {
    @BeforeClass
    public void validateExtensionPresent(ITestContext testContext) throws SQLException {
        Assert.assertTrue(DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), ErrorMessage.format("ConformanceClassDisabled", "RTree Spatial Index Extension"));
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT COUNT(*) FROM gpkg_extensions WHERE extension_name = 'gpkg_rtree_index';");){
            resultSet1.next();
            Assert.assertTrue(resultSet1.getInt(1) > 0, ErrorMessage.format("ConformanceClassDisabled", "RTree Spatial Index Extension"));
        }
    }

    @BeforeClass
    public void setUp() throws SQLException {
    }

    @Test(description="See OGC 12-128r14: Requirement 76")
    public void extensionsTableRows() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT table_name, column_name, scope FROM gpkg_extensions WHERE extension_name = 'gpkg_rtree_index'");){
            while (resultSet1.next()) {
                resultSet1.getString("column_name");
                Assert.assertTrue(!resultSet1.wasNull(), ErrorMessage.format("InvalidRTreeReference", resultSet1.getString("table_name"), resultSet1.getString("column_name")));
                Assert.assertTrue("write-only".equals(resultSet1.getString("scope")), ErrorMessage.format("IllegalExtensionDataScope", "gpkg_rtree_index", "write-only"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r14: Requirement 77")
    public void extensionIndexImplementation() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT table_name, column_name FROM gpkg_geometry_columns WHERE table_name IN (SELECT table_name FROM gpkg_extensions WHERE extension_name == 'gpkg_rtree_index')");){
            while (resultSet1.next()) {
                Statement statement3b;
                block130: {
                    Throwable throwable;
                    String tableName = resultSet1.getString("table_name");
                    String columnName = resultSet1.getString("column_name");
                    try (Statement statement3a = this.databaseConnection.createStatement();){
                        throwable = null;
                        try (ResultSet resultSet3a = statement3a.executeQuery(String.format("SELECT sql FROM sqlite_master WHERE tbl_name = 'rtree_%s_%s'", tableName, columnName));){
                            String index = String.format("CREATE\\s+VIRTUAL\\s+TABLE\\s+\"?rtree_%s_%s\"?\\s+USING\\s+rtree\\s*\\(id,\\s*minx,\\s*maxx,\\s*miny,\\s*maxy\\)", tableName, columnName);
                            String sql3a = resultSet3a.getString("sql");
                            if (!Pattern.compile(index, 2).matcher(sql3a).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "virtual table", tableName, index, sql3a));
                            }
                        }
                        catch (Throwable index) {
                            throwable = index;
                            throw index;
                        }
                    }
                    var8_12 = null;
                    try (Statement statement3d = this.databaseConnection.createStatement();){
                        throwable = null;
                        try (ResultSet resultSet3d = statement3d.executeQuery(String.format("SELECT sql FROM sqlite_master WHERE type='trigger' AND name = 'rtree_%s_%s_delete'", tableName, columnName));){
                            String trigger3d = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_delete\"?\\s+AFTER\\s+DELETE\\s+ON\\s+\"?<t>\"?\\s*WHEN\\s+OLD.\"?<c>\"?\\sNOT\\s*NULL\\s+BEGIN\\s+DELETE\\s+FROM\\s+\"?rtree_<t>_<c>\"?\\s+WHERE\\s+\\w*\\s*=\\s*OLD.\"?\\w*\"?;\\s*END";
                            trigger3d = trigger3d.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            String sql3d = resultSet3d.getString("sql");
                            if (!Pattern.compile(trigger3d, 2).matcher(sql3d).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "delete trigger", tableName, trigger3d, sql3d));
                            }
                        }
                        catch (Throwable trigger3d) {
                            throwable = trigger3d;
                            throw trigger3d;
                        }
                    }
                    catch (Throwable resultSet3d) {
                        var8_12 = resultSet3d;
                        throw resultSet3d;
                    }
                    var8_12 = null;
                    try (Statement statement3c = this.databaseConnection.createStatement();){
                        throwable = null;
                        try (ResultSet resultSet3c = statement3c.executeQuery(String.format("SELECT sql FROM sqlite_master WHERE type='trigger' AND name LIKE 'rtree_%s_%s_update%%' ORDER BY name ASC", tableName, columnName));){
                            resultSet3c.next();
                            String sql3c1 = resultSet3c.getString("sql");
                            String trigger1 = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_update1\"?\\s+AFTER\\s+UPDATE\\s+OF\\s+\"?<c>\"?\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s+OLD.\"?\\w*\"?\\s*=\\s*NEW.\"?\\w*\"?\\s+AND\\s+\\(NEW.\"?<c>\"?\\s+NOT\\s*NULL\\s+AND\\s+NOT\\s+ST_IsEmpty\\s*\\(NEW.\"?<c>\"?\\)\\)\\s+BEGIN\\s+INSERT\\s+OR\\s+REPLACE\\s+INTO\\s+\"?rtree_<t>_<c>\"?\\s+VALUES\\s*\\(\\s*NEW.\"?\\w*\"?,\\s*ST_MinX\\(NEW.\"?<c>\"?\\),\\s*ST_MaxX\\(NEW.\"?<c>\"?\\),\\s*ST_MinY\\(NEW.\"?<c>\"?\\),\\s*ST_MaxY\\(NEW.\"?<c>\"?\\)\\s*\\);\\s*END;?";
                            trigger1 = trigger1.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            if (!Pattern.compile(trigger1, 2).matcher(sql3c1).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "update trigger 1", tableName, trigger1, sql3c1));
                            }
                            resultSet3c.next();
                            String sql3c2 = resultSet3c.getString("sql");
                            String trigger2 = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_update2\"?\\s+AFTER\\s+UPDATE\\s+OF\\s+\"?<c>\"?\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s+OLD.\"?\\w*\"?\\s*=\\s*NEW.\"?\\w*\"?\\s+AND\\s+\\(\\s*NEW.\"?<c>\"?\\s+IS\\s*NULL\\s+OR\\s+ST_IsEmpty\\s*\\(\\s*NEW.\"?<c>\"?\\)\\)\\s+BEGIN\\s+DELETE\\s+FROM\\s+\"?rtree_<t>_<c>\"?\\s+WHERE\\s+\\w*\\s*=\\s*OLD.\"?\\w*\"?;\\s*END";
                            trigger2 = trigger2.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            if (!Pattern.compile(trigger2, 2).matcher(sql3c2).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "update trigger 2", tableName, trigger2, sql3c2));
                            }
                            resultSet3c.next();
                            String sql3c3 = resultSet3c.getString("sql");
                            String trigger3 = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_update3\"?\\s+AFTER\\s+UPDATE\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s+OLD.\"?\\w*\"?\\s*!=\\s*NEW.\"?\\w*\"?\\s+AND\\s+\\(\\s*NEW.\"?<c>\"?\\s+NOT\\s*NULL\\s+AND\\s+NOT\\s+ST_IsEmpty\\s*\\(\\s*NEW.\"?<c>\"?\\)\\)\\s*BEGIN\\s+DELETE\\s+FROM\\s+\"?rtree_<t>_<c>\"?\\s+WHERE\\s+\\w*\\s*=\\s*OLD.\"?\\w*\"?;\\s+INSERT\\s+OR\\s+REPLACE\\s+INTO\\s+\"?rtree_<t>_<c>\"?\\s+VALUES\\s*\\(\\s*NEW.\"?\\w*\"?,\\s*ST_MinX\\(\\s*NEW.\"?<c>\"?\\),\\s*ST_MaxX\\(NEW.\"?<c>\"?\\),\\s*ST_MinY\\(\\s*NEW.\"?<c>\"?\\),\\s*ST_MaxY\\(\\s*NEW.\"?<c>\"?\\)\\s*\\);\\s*END";
                            trigger3 = trigger3.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            if (!Pattern.compile(trigger3, 2).matcher(sql3c3).matches()) {
                                String trigger3old = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_update3\"?\\s+AFTER\\s+UPDATE\\s+OF\\s+\"?<c>\"?\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s+OLD.\"?\\w*\"?\\s*!=\\s*NEW.\"?\\w*\"?\\s+AND\\s+\\(\\s*NEW.\"?<c>\"?\\s+NOT\\s*NULL\\s+AND\\s+NOT\\s+ST_IsEmpty\\s*\\(\\s*NEW.\"?<c>\"?\\)\\)\\s*BEGIN\\s+DELETE\\s+FROM\\s+\"?rtree_<t>_<c>\"?\\s+WHERE\\s+\\w*\\s*=\\s*OLD.\"?\\w*\"?;\\s+INSERT\\s+OR\\s+REPLACE\\s+INTO\\s+\"?rtree_<t>_<c>\"?\\s+VALUES\\s*\\(\\s*NEW.\"?\\w*\"?,\\s*ST_MinX\\(\\s*NEW.\"?<c>\"?\\),\\s*ST_MaxX\\(NEW.\"?<c>\"?\\),\\s*ST_MinY\\(\\s*NEW.\"?<c>\"?\\),\\s*ST_MaxY\\(\\s*NEW.\"?<c>\"?\\)\\s*\\);\\s*END";
                                trigger3old = trigger3old.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                                if (!(this.geopackageVersion != GeoPackageVersion.V102 && this.geopackageVersion != GeoPackageVersion.V110 && this.geopackageVersion != GeoPackageVersion.V120 || Pattern.compile(trigger3old, 2).matcher(sql3c3).matches())) {
                                    Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "update trigger 3", tableName, trigger3, sql3c3));
                                }
                            }
                            resultSet3c.next();
                            String sql3c4 = resultSet3c.getString("sql");
                            String trigger4 = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_update4\"?\\s+AFTER\\s+UPDATE\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s+OLD.\"?\\w*\"?\\s*!=\\s*NEW.\"?\\w*\"?\\s+AND\\s+\\(\\s*NEW.\"?<c>\"?\\s+IS\\s*NULL\\s+OR\\s+ST_IsEmpty\\s*\\(\\s*NEW.\"?<c>\"?\\)\\)\\s*BEGIN\\s+DELETE\\s+FROM\\s+\"?rtree_<t>_<c>\"?\\s+WHERE\\s+\\w*\\sIN\\s*\\(\\s*OLD.\"?\\w*\"?\\s*,\\s*NEW.\"?\\w*\"?\\);\\s*END";
                            trigger4 = trigger4.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            if (!Pattern.compile(trigger4, 2).matcher(sql3c4).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "update trigger 4", tableName, trigger4, sql3c4));
                            }
                        }
                        catch (Throwable sql3c1) {
                            throwable = sql3c1;
                            throw sql3c1;
                        }
                    }
                    catch (Throwable resultSet3c) {
                        var8_12 = resultSet3c;
                        throw resultSet3c;
                    }
                    statement3b = this.databaseConnection.createStatement();
                    var8_12 = null;
                    try {
                        throwable = null;
                        try (ResultSet resultSet3b = statement3b.executeQuery(String.format("SELECT sql FROM sqlite_master WHERE type='trigger' AND name = 'rtree_%s_%s_insert'", tableName, columnName));){
                            String trigger3b = "CREATE\\s+TRIGGER\\s+\"?rtree_<t>_<c>_insert\"?\\s+AFTER\\s+INSERT\\s+ON\\s+\"?<t>\"?\\s+WHEN\\s*\\(new.\"?<c>\"?\\s+NOT\\s*NULL\\s+AND\\s+NOT\\s+ST_IsEmpty\\(NEW.\"?<c>\"?\\)\\)\\s+BEGIN\\s+INSERT\\s+OR\\s+REPLACE\\s+INTO\\s+\"?rtree_<t>_<c>\"?\\s+VALUES\\s+\\(\\s*NEW.\"?\\w+\"?,\\s*ST_MinX\\(NEW.\"?<c>\"?\\),\\s*ST_MaxX\\(NEW.\"?<c>\"?\\),\\s*ST_MinY\\(NEW.\"?<c>\"?\\),\\s*ST_MaxY\\(NEW.\"?<c>\"?\\)\\s*\\);\\s*END;?";
                            trigger3b = trigger3b.replaceAll("<t>", tableName).replaceAll("<c>", columnName);
                            String sql3b = resultSet3b.getString("sql");
                            if (!Pattern.compile(trigger3b, 2).matcher(sql3b).matches()) {
                                Assert.fail(ErrorMessage.format("InvalidRTreeDefinition", "insert trigger", tableName, trigger3b, sql3b));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        if (statement3b == null) continue;
                        if (var8_12 == null) break block130;
                    }
                    catch (Throwable throwable3) {
                        try {
                            var8_12 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (statement3b == null) throw throwable4;
                            if (var8_12 != null) {
                                try {
                                    statement3b.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    var8_12.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                            statement3b.close();
                            throw throwable4;
                        }
                    }
                    try {
                        statement3b.close();
                        continue;
                    }
                    catch (Throwable throwable6) {
                        var8_12.addSuppressed(throwable6);
                        continue;
                    }
                }
                statement3b.close();
            }
            return;
        }
    }
}

