/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.features;

import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg12.ColumnDefinition;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.FeaturesFixture;
import org.opengis.cite.gpkg12.TableVerifier;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.gpkg12.util.GeoPackageVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeaturesTests
extends FeaturesFixture {
    private final Boolean NativeOrderIsBE = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private static final Map<String, ColumnDefinition> FeatureTableExpectedColumns;
    private static final Map<String, List<String>> GeometrySubtypesAllowed;
    private boolean hasGeometryColumnsTable;
    private boolean hasGPKGExtensionsTable;
    private final Collection<String> possibleFeatureTableNames = new ArrayList<String>();
    private final Collection<String> featureTableNames = new ArrayList<String>();
    int errorDetected19 = 0;
    int errorDetected32 = 0;
    int errorDetected33 = 0;
    int errorDetectedNSG19b = 0;
    int errorDetected66 = 0;
    int errorDetected67 = 0;
    int errorDetected78 = 0;
    int errorDetected20 = 0;
    private static final int maxErrorsToReport19 = 15;
    private static final int maxErrorsToReport32 = 5;
    private static final int maxErrorsToReport33 = 5;
    private static final int maxErrorsToReport66 = 5;
    private static final int maxErrorsToReport67 = 5;
    private static final int maxErrorsToReport78 = 5;
    private static final int maxErrorsToReport20 = 5;
    private static final byte maskFlagBinaryType = 32;
    private static final int shiftFlagBinaryType = 5;
    private static final byte maskFlagEmptyGeometry = 16;
    private static final int shiftFlagEmptyGeometry = 4;
    private static final byte maskFlagEnvelope = 14;
    private static final int shiftFlagEnvelope = 1;
    private static final byte maskFlagHeaderEndian = 1;
    private static final int startOfVersion = 2;
    private static final int startOfFlags = 3;
    private static final int startOfSRIDIndex = 4;
    private static final int startOfEnvelopeIndex = 8;
    private static final int startOfGeometryType = 1;
    private static final int maximumEnvelopeSize = 64;
    private static final String myminx = "minx";
    private static final String myminy = "miny";
    private static final String mymaxx = "maxx";
    private static final String mymaxy = "maxy";
    private static final String myminz = "minz";
    private static final String mymaxz = "maxz";
    private static final String myminm = "minm";
    private static final String mymaxm = "maxm";
    private static final String geomCIRCULARSTRING = "CIRCULARSTRING";
    private static final String geomCOMPOUNDCURVE = "COMPOUNDCURVE";
    private static final String geomCURVEPOLYGON = "CURVEPOLYGON";
    private static final String geomMULTICURVE = "MULTICURVE";
    private static final String geomMULTISURFACE = "MULTISURFACE";
    private static final String geomCURVE = "CURVE";
    private static final String geomSURFACE = "SURFACE";
    private static final String geomUNSUPPORTED = "UNSUPPORTED";

    @BeforeClass
    public void setUp() throws SQLException {
        Throwable throwable;
        ResultSet resultSet;
        this.hasGeometryColumnsTable = DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_geometry_columns");
        this.hasGPKGExtensionsTable = DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions");
        try (Statement statement = this.databaseConnection.createStatement();){
            resultSet = statement.executeQuery("SELECT tbl_name FROM sqlite_master WHERE tbl_name NOT LIKE 'gpkg_%' AND (type = 'tile' OR type = 'view');");
            throwable = null;
            try {
                while (resultSet.next()) {
                    try {
                        String tableName = resultSet.getString("tbl_name");
                        TableVerifier.verifyTable(this.databaseConnection, tableName, FeatureTableExpectedColumns, null, null);
                        this.possibleFeatureTableNames.add(tableName);
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features';");
            throwable = null;
            try {
                while (resultSet.next()) {
                    this.featureTableNames.add(resultSet.getString(1));
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            var2_2 = throwable7;
            throw throwable7;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable8) {
                        var2_2.addSuppressed(throwable8);
                    }
                } else {
                    statement.close();
                }
            }
        }
        Assert.assertTrue(!this.featureTableNames.isEmpty(), ErrorMessage.format("ConformanceClassDisabled", this.getTestName()));
    }

    @DataProvider(name="feature-geometry-information")
    public Iterator<Object[]> getFeaturesWithGeometryInfo() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name AS tn, column_name AS cn, srs_id, geometry_type_name AS gt_name, z as z_flag, m as m_flag FROM gpkg_geometry_columns WHERE table_name IN (SELECT table_name FROM gpkg_contents WHERE data_type = 'features');");){
            while (resultSet.next()) {
                Object[] tuple = new Object[]{resultSet.getString("tn"), resultSet.getString("cn"), resultSet.getString("gt_name").toUpperCase(), resultSet.getInt("srs_id"), (byte)resultSet.getInt("z_flag"), (byte)resultSet.getInt("m_flag")};
                data.add(tuple);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return data.iterator();
    }

    @Test(description="See OGC 12-128r14: Requirement 18")
    public void features_contents_data_features_row() throws SQLException {
        Collection missingFeatureTableNames = this.possibleFeatureTableNames.stream().filter(tableName -> !this.featureTableNames.contains(tableName)).collect(Collectors.toList());
        String reportOut = String.join((CharSequence)", ", missingFeatureTableNames);
        Assert.assertTrue(missingFeatureTableNames == null || missingFeatureTableNames.isEmpty(), ErrorMessage.format("FeatureTableNamesMissing", reportOut));
    }

    @Test(description="See OGC 12-128r13: Requirement 29")
    public void featureTableIntegerPrimaryKey() throws SQLException {
        for (String tableName : this.featureTableNames) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
                Assert.assertTrue(resultSet.next(), ErrorMessage.format("MissingTable", tableName));
            }
            this.checkPrimaryKey(tableName, this.getPrimaryKeyColumn(tableName, false), false);
        }
    }

    @Test(description="See OGC 12-128r14: Requirements 19, 20, 32, 33, 66 (partial), 67, 78; and NSG Requirement 19B", dataProvider="feature-geometry-information")
    public void featureGeometryEncodingTesting(String thisTableName, String thisColumnName, String geomType, Integer srs_id, byte z_flag, byte m_flag) throws SQLException {
        try (Statement statementInternal = this.databaseConnection.createStatement();
             ResultSet resultSetInternal = statementInternal.executeQuery(String.format("SELECT rowid, %s as geom FROM '%s';", thisColumnName, thisTableName));){
            int MAX_COUNT = 100;
            int counter = 0;
            while (resultSetInternal.next() && counter < 100) {
                int envelopeSize;
                byte emptyGeometryFlag;
                byte[] bytes;
                long rowID;
                block111: {
                    ++counter;
                    rowID = resultSetInternal.getLong(1);
                    bytes = resultSetInternal.getBytes("geom");
                    if (bytes == null) continue;
                    byte envelopeCode = (byte)((bytes[3] & 0xE) >> 1);
                    byte binaryTypeFlag = (byte)((bytes[3] & 0x20) >> 5);
                    emptyGeometryFlag = (byte)((bytes[3] & 0x10) >> 4);
                    byte headerLE = (byte)(bytes[3] & 1);
                    HashMap<String, Double> envelopeVals = new HashMap<String, Double>();
                    envelopeSize = this.mygetEnvelopeByteSize(envelopeCode);
                    boolean swapHeaderBytes = this.NativeOrderIsBE != false && headerLE == 1 || this.NativeOrderIsBE == false && headerLE == 0;
                    boolean nanDetected = false;
                    try {
                        byte version;
                        byte[] GP_HEADER = new String("GP").getBytes(StandardCharsets.US_ASCII);
                        if (bytes[0] != GP_HEADER[0] || bytes[1] != GP_HEADER[1]) {
                            ++this.errorDetected19;
                            if (this.errorDetected19 < 15) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnInvalidMagicNumber", thisTableName, rowID, thisColumnName, String.format("0x%02x%02x", bytes[0], bytes[1])));
                            }
                        }
                        if ((version = bytes[2]) != 0) {
                            ++this.errorDetected19;
                            if (this.errorDetected19 < 15) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnInvalidVersion", thisTableName, rowID, thisColumnName, version));
                            }
                        }
                        if (binaryTypeFlag != 0) {
                            ++this.errorDetected19;
                            if (this.errorDetected19 < 15) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnInvalidBinaryCode", thisTableName, rowID, thisColumnName, binaryTypeFlag));
                            }
                        }
                        if (envelopeCode > 4 || envelopeCode < 0) {
                            ++this.errorDetected19;
                            if (this.errorDetected19 < 15) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnInvalidEnvelopeCode", thisTableName, rowID, thisColumnName, envelopeCode));
                            }
                        }
                    }
                    catch (Exception th) {
                        AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 19i-iv on feature {0}", thisTableName), th.getMessage()));
                    }
                    byte[] srspartID = this.byteArraySubset(bytes, 4, 4);
                    int currentSRID = this.getIntegerFromBytesWithPossibleSwap(srspartID, swapHeaderBytes);
                    try {
                        if (currentSRID != srs_id) {
                            int tempSRID = Integer.reverseBytes(currentSRID);
                            if (tempSRID == srs_id) {
                                ++this.errorDetected33;
                                if (this.errorDetected33 < 5) {
                                    Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnSRSMatchWhenBytesSwapped", rowID, thisColumnName, currentSRID, srs_id, thisTableName));
                                }
                            } else {
                                ++this.errorDetected33;
                                if (this.errorDetected33 < 5) {
                                    Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnSRSDoesNotMatchSpecifiedSRSForFeature", rowID, thisColumnName, currentSRID, srs_id, thisTableName));
                                }
                            }
                        }
                    }
                    catch (Exception th) {
                        AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 33 part b on feature {0}", thisTableName), th.getMessage()));
                    }
                    try {
                        if (envelopeSize <= 0 || envelopeSize >= 64) break block111;
                        byte[] bytesEnvelope = this.byteArraySubset(bytes, 8, envelopeSize);
                        try {
                            this.mygetEnvelope(envelopeSize, swapHeaderBytes, bytesEnvelope, envelopeVals);
                        }
                        catch (IllegalArgumentException ee) {
                            nanDetected = true;
                        }
                        if (!nanDetected && emptyGeometryFlag != 0) {
                            ++this.errorDetected19;
                            if (this.errorDetected19 < 15) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnDetectedEmptyGeometryFlagButEnvelopeHasContent", rowID, thisColumnName, thisTableName));
                            }
                        }
                    }
                    catch (Exception th) {
                        AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 19v on feature {0}", thisTableName), th.getMessage()));
                    }
                }
                String actualGeometryType = geomUNSUPPORTED;
                if (emptyGeometryFlag != 0) continue;
                int geometryStart = 8 + envelopeSize;
                byte geometryByteOrderLE = bytes[geometryStart];
                boolean swapGeometryBytes = geometryByteOrderLE == 1 && this.NativeOrderIsBE != false || geometryByteOrderLE == 0 && this.NativeOrderIsBE == false;
                byte[] geomtypeBytes = this.byteArraySubset(bytes, geometryStart + 1, 4);
                int currentGeomType = this.getIntegerFromBytesWithPossibleSwap(geomtypeBytes, swapGeometryBytes);
                actualGeometryType = this.getGeomTypeFromNum(currentGeomType).toUpperCase();
                try {
                    if (actualGeometryType.equals(geomUNSUPPORTED)) {
                        int altGeomType = this.getIntegerFromBytesWithPossibleSwap(geomtypeBytes, !swapGeometryBytes);
                        String testGeomType = this.getGeomTypeFromNum(altGeomType).toUpperCase();
                        if (testGeomType.equals(geomUNSUPPORTED)) {
                            ++this.errorDetected20;
                            if (this.errorDetected20 < 5) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnGeometryTypeNotValid", rowID, thisColumnName, geomType, currentGeomType, thisTableName));
                            }
                        } else {
                            ++this.errorDetected20;
                            if (this.errorDetected20 < 5) {
                                Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnGeometryTypeNotValidButByteSwapErrorPossible", rowID, thisColumnName, geomType, currentGeomType, thisTableName, altGeomType, testGeomType));
                            }
                        }
                    }
                }
                catch (Exception th) {
                    AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 20 on feature {0}", thisTableName), th.getMessage()));
                }
                try {
                    if (this.IsAssignable(geomType, actualGeometryType) == 0) {
                        ++this.errorDetected32;
                        if (this.errorDetected32 < 5) {
                            Assert.assertTrue(false, ErrorMessage.format("Feature_GeometryColumnGeometryNotAssignableToSupertype", rowID, thisColumnName, geomType, actualGeometryType, thisTableName));
                        }
                    }
                }
                catch (Exception th) {
                    AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 32 on feature {0}", thisTableName), th.getMessage()));
                }
                int geometryItemCount = 1;
                if (actualGeometryType != "POINT") {
                    byte[] wkbGeometryCount = this.byteArraySubset(bytes, geometryStart + 1 + 4, 4);
                    geometryItemCount = this.getIntegerFromBytesWithPossibleSwap(wkbGeometryCount, swapGeometryBytes);
                }
                if (geometryItemCount < 0) {
                    ++this.errorDetected66;
                    if (this.errorDetected66 < 5) {
                        Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryWKBItemCountIllegal", thisTableName, rowID, thisColumnName, actualGeometryType, geometryItemCount));
                    }
                }
                if (!this.hasGPKGExtensionsTable) continue;
                try {
                    Throwable throwable;
                    ResultSet resultSetST;
                    boolean testForGeomExtensions = false;
                    try (Statement statementST = this.databaseConnection.createStatement();){
                        resultSetST = statementST.executeQuery(String.format("SELECT extension_name FROM gpkg_extensions WHERE (extension_name LIKE 'gpkg_geom_');", new Object[0]));
                        throwable = null;
                        try {
                            if (resultSetST.next()) {
                                testForGeomExtensions = true;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resultSetST != null) {
                                if (throwable != null) {
                                    try {
                                        resultSetST.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    resultSetST.close();
                                }
                            }
                        }
                    }
                    if (!testForGeomExtensions) continue;
                    statementST = this.databaseConnection.createStatement();
                    var35_50 = null;
                    try {
                        resultSetST = statementST.executeQuery(String.format("SELECT extension_name FROM gpkg_extensions WHERE (table_name = '%s' AND column_name = '%s' AND extension_name = 'gpkg_geom_%s');", thisTableName, thisColumnName, actualGeometryType));
                        throwable = null;
                        try {
                            if (resultSetST.next()) continue;
                            ++this.errorDetected67;
                            if (this.errorDetected67 >= 5) continue;
                            Assert.assertTrue(false, ErrorMessage.format("FeatureGeometryColumnGeometryTypeNotPresentAsExtension", rowID, thisColumnName, actualGeometryType, actualGeometryType, thisTableName));
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (resultSetST == null) continue;
                            if (throwable != null) {
                                try {
                                    resultSetST.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            resultSetST.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        var35_50 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statementST == null) continue;
                        if (var35_50 != null) {
                            try {
                                statementST.close();
                            }
                            catch (Throwable throwable7) {
                                var35_50.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        statementST.close();
                    }
                }
                catch (Exception th) {
                    AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", String.format("Failure testing requirement 67 on feature {0}", thisTableName), th.getMessage()));
                }
            }
        }
        catch (Exception th) {
            AssertJUnit.fail(ErrorMessage.format("FeatureGeometryColumnBLOBProcessingTestFailure", "main loop", th.getMessage()));
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 21")
    public void featureGeometryColumnsTableDef() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_geometry_columns');");){
            int passFlag = 0;
            int flagMask = 63;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("geometry_type_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("pk") == 0, "FeaturesGeometryColumnsInvalid");
                    passFlag |= 1;
                    continue;
                }
                if ("table_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("pk") == 1, "FeaturesGeometryColumnsInvalid");
                    passFlag |= 2;
                    continue;
                }
                if ("m".equals(name)) {
                    Assert.assertTrue("TINYINT".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("pk") == 0, "FeaturesGeometryColumnsInvalid");
                    passFlag |= 4;
                    continue;
                }
                if ("z".equals(name)) {
                    Assert.assertTrue("TINYINT".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("pk") == 0, "FeaturesGeometryColumnsInvalid");
                    passFlag |= 8;
                    continue;
                }
                if ("srs_id".equals(name)) {
                    Assert.assertTrue("INTEGER".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                    Assert.assertTrue(resultSet.getInt("pk") == 0, "FeaturesGeometryColumnsInvalid");
                    passFlag |= 0x10;
                    continue;
                }
                if (!"column_name".equals(name)) continue;
                Assert.assertTrue("TEXT".equals(resultSet.getString("type")), "FeaturesGeometryColumnsInvalid");
                Assert.assertTrue(resultSet.getInt("notnull") == 1, "FeaturesGeometryColumnsInvalid");
                Assert.assertTrue(resultSet.getInt("pk") == 2, "FeaturesGeometryColumnsInvalid");
                passFlag |= 0x20;
            }
            Assert.assertTrue((passFlag & 0x3F) == 63, "FeaturesGeometryColumnsInvalid");
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 22")
    public void featureGeometryColumnsDataValues() throws SQLException {
        block48: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features';");){
                if (!resultSet.next()) break block48;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'features' AND table_name NOT IN (SELECT table_name FROM gpkg_geometry_columns);");){
                    Assert.assertTrue(!resultSet2.next(), "FeaturesGeometryColumnsMismatch");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 23, 26")
    public void featureGeometryColumnsDataValuesTableName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_list('gpkg_geometry_columns');");){
            boolean foundContents = false;
            boolean foundSpatialRefSys = false;
            while (resultSet.next()) {
                String table = resultSet.getString("table");
                if ("gpkg_spatial_ref_sys".equals(table)) {
                    if (!"srs_id".equals(resultSet.getString("from")) || !"srs_id".equals(resultSet.getString("to"))) continue;
                    foundSpatialRefSys = true;
                    continue;
                }
                if (!"gpkg_contents".equals(table) || !"table_name".equals(resultSet.getString("from")) || !"table_name".equals(resultSet.getString("to"))) continue;
                foundContents = true;
            }
            Assert.assertTrue(foundContents && foundSpatialRefSys, "FeaturesGeometryColumnsNoFK");
        }
    }

    @Test(description="See OGC 12-128r14: Requirement 23")
    public void featureGeometryColumnsDataValuesTableNameNEW() throws SQLException {
        if (this.hasGeometryColumnsTable) {
            ArrayList<String> reportFKIssues = new ArrayList<String>();
            int countResults = 0;
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_list('gpkg_geometry_columns');");){
                while (resultSet.next()) {
                    Boolean testFailedForFKItem = true;
                    String thisTableName = resultSet.getString("table");
                    String thisColumnTo = resultSet.getString("to");
                    ++countResults;
                    try (Statement preparedStatement = this.databaseConnection.createStatement();
                         ResultSet pragmaTableInfo = preparedStatement.executeQuery(String.format("PRAGMA table_info('%s');", thisTableName));){
                        while (pragmaTableInfo.next() && testFailedForFKItem.booleanValue()) {
                            String columnName = pragmaTableInfo.getString("name");
                            if (!thisColumnTo.equals(columnName)) continue;
                            testFailedForFKItem = false;
                        }
                    }
                    if (!testFailedForFKItem.booleanValue()) continue;
                    reportFKIssues.add(thisTableName);
                }
            }
            if (countResults == 0) {
                reportFKIssues.add("No foreign key specified in gpkg_geometry_columns");
            }
            String reportOut = String.join((CharSequence)", ", reportFKIssues);
            Assert.assertTrue(reportFKIssues == null || reportFKIssues.isEmpty(), ErrorMessage.format("FeatureForeignKeyNotSpecifiedCorrectly", reportOut));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 24")
    public void featureGeometryColumnsDataValuesColumnName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name FROM gpkg_geometry_columns;");){
            while (resultSet.next()) {
                Statement statement2;
                block48: {
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info('%s');", tableName));){
                            boolean foundMatch = false;
                            while (resultSet2.next()) {
                                if (!resultSet2.getString("name").equals(columnName)) continue;
                                foundMatch = true;
                                break;
                            }
                            Assert.assertTrue(foundMatch, ErrorMessage.format("FeaturesGeometryColumnsInvalidCol", tableName, columnName));
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 146")
    public void featureGeometryColumnsDataValuesSrsId() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT a.srs_id srs_id, a.table_name tn FROM gpkg_geometry_columns a, gpkg_contents b WHERE a.table_name = b.table_name and a.srs_id != b.srs_id");){
            if (resultSet.next()) {
                AssertJUnit.fail(ErrorMessage.format("SRSMismatch", "gpkg_geometry_columns", resultSet.getInt("srs_id"), resultSet.getString("tn")));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 25")
    public void featureGeometryColumnsDataValuesGeometryType() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns");){
            while (resultSet.next()) {
                String geometryTypeName = resultSet.getString("geometry_type_name");
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                boolean pass = false;
                if (this.geopackageVersion.equals((Object)GeoPackageVersion.V120)) {
                    pass = ALLOWED_GEOMETRY_TYPES.contains(geometryTypeName);
                } else {
                    Iterator iterator = ALLOWED_GEOMETRY_TYPES.iterator();
                    while (iterator.hasNext()) {
                        if (!geometryTypeName.equalsIgnoreCase((String)iterator.next())) continue;
                        pass = true;
                        break;
                    }
                }
                if (!pass) {
                    pass = this.isExtendedType(tableName, columnName);
                }
                Assert.assertTrue(pass, ErrorMessage.format("FeaturesGeometryColumnsInvalidGeom", geometryTypeName, tableName));
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 27")
    public void featureGeometryColumnsDataValuesZ() throws SQLException {
        block49: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT z FROM gpkg_geometry_columns");){
                if (!resultSet.next()) break block49;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT z FROM gpkg_geometry_columns WHERE z NOT IN (0,1,2)");){
                    if (resultSet2.next()) {
                        Assert.assertTrue(false, ErrorMessage.format("FeaturesGeometryColumnsInvalidZ", resultSet2.getInt("z")));
                    }
                }
            }
        }
    }

    @Test(description="See OGC 12-128r13: Requirement 28")
    public void featureGeometryColumnsDataValuesM() throws SQLException {
        block49: {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT m FROM gpkg_geometry_columns");){
                if (!resultSet.next()) break block49;
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("SELECT m FROM gpkg_geometry_columns WHERE m NOT IN (0,1,2)");){
                    if (resultSet2.next()) {
                        Assert.assertTrue(false, ErrorMessage.format("FeaturesGeometryColumnsInvalidM", resultSet2.getInt("m")));
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 30")
    public void featureTableOneGeometryColumn() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type='features'");){
            while (resultSet.next()) {
                Statement statement2;
                block47: {
                    String tableName = resultSet.getString("table_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT count(*) FROM gpkg_geometry_columns WHERE table_name = '%s'", tableName));){
                            resultSet2.next();
                            Assert.assertTrue(resultSet2.getInt(1) == 1, "FeaturesOneGeometryColumn");
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block47;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r13: Requirement 31")
    public void featureTableGeometryColumnType() throws SQLException {
        if (!this.geopackageVersion.equals((Object)GeoPackageVersion.V120)) return;
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, geometry_type_name FROM gpkg_geometry_columns WHERE table_name IN (SELECT table_name FROM gpkg_contents WHERE data_type = 'features')");){
            while (resultSet.next()) {
                Statement statement2;
                block48: {
                    String geometryTypeName = resultSet.getString("geometry_type_name");
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    statement2 = this.databaseConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        try (ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info('%s')", tableName));){
                            while (resultSet2.next()) {
                                if (!columnName.equals(resultSet2.getString("name"))) continue;
                                Assert.assertTrue(geometryTypeName.equals(resultSet2.getString("type")), "FeaturesGeometryColumnsMismatch");
                                break;
                            }
                        }
                        if (statement2 == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (statement2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    statement2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            statement2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        statement2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                statement2.close();
            }
            return;
        }
    }

    private int getIntegerFromBytesWithPossibleSwap(byte[] bytesIn, boolean swapFlag) {
        int returnValue = 0;
        if (bytesIn.length == 4) {
            returnValue = !swapFlag && this.NativeOrderIsBE.booleanValue() || swapFlag && !this.NativeOrderIsBE.booleanValue() ? new BigInteger(bytesIn).intValue() : Integer.reverseBytes(new BigInteger(bytesIn).intValue());
        } else {
            throw new IllegalArgumentException("Invalid byte array length");
        }
        return returnValue;
    }

    private long getLongFromBytesWithPossibleSwap(byte[] bytesIn, boolean swapFlag) {
        long returnValue = 0L;
        if (bytesIn.length == 8) {
            returnValue = !swapFlag && this.NativeOrderIsBE.booleanValue() || swapFlag && !this.NativeOrderIsBE.booleanValue() ? new BigInteger(bytesIn).longValue() : Long.reverseBytes(new BigInteger(bytesIn).longValue());
        } else {
            throw new IllegalArgumentException("Invalid byte array length");
        }
        return returnValue;
    }

    private double getDoubleFromBytesWithPossibleSwap(byte[] bytesIn, boolean swapFlag) {
        long tempLong;
        double returnValue = 0.0;
        if (bytesIn.length == 8) {
            tempLong = this.getLongFromBytesWithPossibleSwap(bytesIn, swapFlag);
            if (this.isLongRepresentationNaN(tempLong)) {
                throw new IllegalArgumentException("NaN");
            }
        } else {
            throw new IllegalArgumentException("Invalid byte array length");
        }
        returnValue = Double.longBitsToDouble(tempLong);
        return returnValue;
    }

    private boolean isLongRepresentationNaN(long inValue) {
        return this.NativeOrderIsBE != false && inValue == 9221120237041090560L || this.NativeOrderIsBE == false && inValue == 63615L;
    }

    private boolean isDoubleRepresentationNaNorInfinity(Double inValue) {
        return Double.isNaN(inValue) || Double.isInfinite(inValue);
    }

    private String getGeomTypeFromNum(int geomTypeIn) {
        String result = "";
        switch (geomTypeIn) {
            case 0: 
            case 1000: 
            case 2000: 
            case 3000: {
                result = "GEOMETRY";
                break;
            }
            case 1: 
            case 1001: 
            case 2001: 
            case 3001: {
                result = "POINT";
                break;
            }
            case 2: 
            case 1002: 
            case 2002: 
            case 3002: {
                result = "LINESTRING";
                break;
            }
            case 3: 
            case 1003: 
            case 2003: 
            case 3003: {
                result = "POLYGON";
                break;
            }
            case 4: 
            case 1004: 
            case 2004: 
            case 3004: {
                result = "MULTIPOINT";
                break;
            }
            case 5: 
            case 1005: 
            case 2005: 
            case 3005: {
                result = "MULTILINESTRING";
                break;
            }
            case 6: 
            case 1006: 
            case 2006: 
            case 3006: {
                result = "MULTIPOLYGON";
                break;
            }
            case 7: 
            case 1007: 
            case 2007: 
            case 3007: {
                result = "GEOMETRYCOLLECTION";
                break;
            }
            case 8: 
            case 1008: 
            case 2008: 
            case 3008: {
                result = geomCIRCULARSTRING;
                break;
            }
            case 9: 
            case 1009: 
            case 2009: 
            case 3009: {
                result = geomCOMPOUNDCURVE;
                break;
            }
            case 10: 
            case 1010: 
            case 2010: 
            case 3010: {
                result = geomCURVEPOLYGON;
                break;
            }
            case 11: 
            case 1011: 
            case 2011: 
            case 3011: {
                result = geomMULTICURVE;
                break;
            }
            case 12: 
            case 1012: 
            case 2012: 
            case 3012: {
                result = geomMULTISURFACE;
                break;
            }
            case 13: 
            case 1013: 
            case 2013: 
            case 3013: {
                result = geomCURVE;
                break;
            }
            case 14: 
            case 1014: 
            case 2014: 
            case 3014: {
                result = geomSURFACE;
                break;
            }
            default: {
                result = geomUNSUPPORTED;
            }
        }
        return result;
    }

    private int IsAssignable(String supertypeGeometry, String subtypeGeometry) {
        int returnValue = 0;
        if (!supertypeGeometry.isEmpty() && !subtypeGeometry.isEmpty() && (supertypeGeometry.equals(subtypeGeometry) || GeometrySubtypesAllowed.containsKey(supertypeGeometry) && GeometrySubtypesAllowed.get(supertypeGeometry).contains(subtypeGeometry))) {
            returnValue = 1;
        }
        return returnValue;
    }

    private byte[] byteArraySubset(byte[] bytesIn, int startIndex, int numberOfBytes) {
        byte[] subsetArray = new byte[numberOfBytes];
        if (startIndex + numberOfBytes > bytesIn.length) {
            throw new IllegalArgumentException(String.format("Invalid numberOfBytes value: %d or startIndex %d. The startIndex + numberOfBytes exceed the length of the byte array.", numberOfBytes, startIndex));
        }
        System.arraycopy(bytesIn, startIndex, subsetArray, 0, numberOfBytes);
        return subsetArray;
    }

    private boolean mygetEnvelope(int bytesExpected, boolean swapFlag, byte[] bytesIn, Map<String, Double> envelopeValues) {
        boolean allzerovalues = true;
        int envelopeIndex = 0;
        Assert.assertTrue(envelopeValues.isEmpty(), "Attempt to get envelope when there are already values");
        if (bytesExpected > 0 && bytesExpected % 8 == 0 && bytesIn.length == bytesExpected) {
            for (int ii = 0; ii < bytesExpected; ii += 8) {
                byte[] envibtem = this.byteArraySubset(bytesIn, ii, 8);
                try {
                    Double tempDouble = this.getDoubleFromBytesWithPossibleSwap(envibtem, swapFlag);
                    if (this.isDoubleRepresentationNaNorInfinity(tempDouble)) {
                        throw new IllegalArgumentException(String.format("NaN value detected.", new Object[0]));
                    }
                    switch (envelopeIndex) {
                        case 0: {
                            envelopeValues.put(myminx, tempDouble);
                            break;
                        }
                        case 1: {
                            envelopeValues.put(mymaxx, tempDouble);
                            break;
                        }
                        case 2: {
                            envelopeValues.put(myminy, tempDouble);
                            break;
                        }
                        case 3: {
                            envelopeValues.put(mymaxy, tempDouble);
                            break;
                        }
                        case 4: {
                            envelopeValues.put(myminz, tempDouble);
                            break;
                        }
                        case 5: {
                            envelopeValues.put(mymaxz, tempDouble);
                            break;
                        }
                        case 6: {
                            envelopeValues.put(myminm, tempDouble);
                            break;
                        }
                        case 7: {
                            envelopeValues.put(mymaxm, tempDouble);
                        }
                    }
                    if (!this.checkIfValueWithinToleranceOfTargetValue(tempDouble, 0.0, 1.0E-10)) {
                        allzerovalues = false;
                    }
                }
                catch (IllegalArgumentException ee) {
                    throw new IllegalArgumentException(ee.getMessage());
                }
                ++envelopeIndex;
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid bytesExpected value: %d. Is 0 or is not divisible by the size of a double or not the size of the byte array parameter.", bytesExpected));
        }
        if (allzerovalues) {
            envelopeValues.clear();
        }
        return !allzerovalues;
    }

    private int mygetEnvelopeByteSize(byte envelopeCode) {
        int bytesExpected = 0;
        switch (envelopeCode) {
            case 0: {
                bytesExpected = 0;
                break;
            }
            case 1: {
                bytesExpected = 32;
                break;
            }
            case 2: 
            case 3: {
                bytesExpected = 48;
                break;
            }
            case 4: {
                bytesExpected = 64;
                break;
            }
            default: {
                bytesExpected = 0;
            }
        }
        return bytesExpected;
    }

    private boolean checkIfValueWithinToleranceOfTargetValue(double valueIn, double targetValue, double tolerance) {
        return !(Math.abs(valueIn - targetValue) > tolerance);
    }

    static {
        GeometrySubtypesAllowed = new HashMap<String, List<String>>();
        GeometrySubtypesAllowed.put(geomCURVE, Arrays.asList("LINESTRING", geomCIRCULARSTRING, geomCOMPOUNDCURVE));
        GeometrySubtypesAllowed.put(geomSURFACE, Arrays.asList(geomCURVEPOLYGON, "POLYGON"));
        GeometrySubtypesAllowed.put(geomCURVEPOLYGON, Arrays.asList("POLYGON", geomCURVE, "LINESTRING", geomCIRCULARSTRING, geomCOMPOUNDCURVE));
        GeometrySubtypesAllowed.put("POLYGON", Arrays.asList("LINESTRING"));
        GeometrySubtypesAllowed.put("GEOMETRYCOLLECTION", Arrays.asList("MULTIPOINT", geomMULTICURVE, geomMULTISURFACE, "MULTIPOLYGON", "MULTILINESTRING"));
        GeometrySubtypesAllowed.put(geomMULTISURFACE, Arrays.asList(geomSURFACE));
        GeometrySubtypesAllowed.put("MULTIPOLYGON", Arrays.asList("POLYGON"));
        GeometrySubtypesAllowed.put(geomMULTICURVE, Arrays.asList(geomCURVE));
        GeometrySubtypesAllowed.put("MULTILINESTRING", Arrays.asList("LINESTRING"));
        GeometrySubtypesAllowed.put("MULTIPOINT", Arrays.asList("POINT"));
        GeometrySubtypesAllowed.put("GEOMETRY", Arrays.asList("POINT", geomCURVE, geomSURFACE, "GEOMETRYCOLLECTION", "LINESTRING", geomCIRCULARSTRING, geomCOMPOUNDCURVE, geomCURVEPOLYGON, "POLYGON", "MULTIPOINT", geomMULTICURVE, geomMULTISURFACE, "MULTIPOLYGON", "MULTILINESTRING"));
        FeatureTableExpectedColumns = new HashMap<String, ColumnDefinition>();
        FeatureTableExpectedColumns.put("id", new ColumnDefinition("INTEGER", false, true, true, null));
        FeatureTableExpectedColumns.put("geometry", new ColumnDefinition("GEOMETRY", true, false, false, null));
    }
}

