/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;

public class MethodInheritance {
    private static List<ITestNGMethod> findMethodListSuperClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        for (Map.Entry<Class, List<ITestNGMethod>> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(methodClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Class findSubClass(Map<Class, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        for (Class cls : map.keySet()) {
            if (!methodClass.isAssignableFrom(cls)) continue;
            return cls;
        }
        return null;
    }

    public static void fixMethodInheritance(ITestNGMethod[] methods, boolean before) {
        Map<Class, List<ITestNGMethod>> map = Maps.newHashMap();
        for (ITestNGMethod method : methods) {
            Class methodClass = method.getRealClass();
            List<ITestNGMethod> l = MethodInheritance.findMethodListSuperClass(map, methodClass);
            if (null != l) {
                l.add(method);
                continue;
            }
            Class subClass = MethodInheritance.findSubClass(map, methodClass);
            if (null != subClass) {
                l = map.get(subClass);
                l.add(method);
                map.remove(subClass);
                map.put(methodClass, l);
                continue;
            }
            l = Lists.newArrayList();
            l.add(method);
            map.put(methodClass, l);
        }
        for (List l : map.values()) {
            if (l.size() <= 1) continue;
            MethodInheritance.sortMethodsByInheritance(l, before);
            for (int i = 0; i < l.size() - 1; ++i) {
                ITestNGMethod m1 = (ITestNGMethod)l.get(i);
                for (int j = i + 1; j < l.size(); ++j) {
                    ITestNGMethod m22 = (ITestNGMethod)l.get(j);
                    if (MethodInheritance.equalsEffectiveClass(m1, m22) || MethodInheritance.dependencyExists(m1, m22, methods)) continue;
                    Utils.log("MethodInheritance", 4, m22 + " DEPENDS ON " + m1);
                    m22.addMethodDependedUpon(MethodHelper.calculateMethodCanonicalName(m1));
                }
            }
        }
    }

    private static boolean dependencyExists(ITestNGMethod m1, ITestNGMethod m22, ITestNGMethod[] methods) {
        return MethodInheritance.internalDependencyExists(m1, m22, methods) || MethodInheritance.internalDependencyExists(m22, m1, methods);
    }

    private static boolean internalDependencyExists(ITestNGMethod m1, ITestNGMethod m22, ITestNGMethod[] methods) {
        ITestNGMethod[] methodsNamed = MethodHelper.findDependedUponMethods(m1, methods);
        for (ITestNGMethod method : methodsNamed) {
            if (!method.equals(m22)) continue;
            return true;
        }
        for (String group : m1.getGroupsDependedUpon()) {
            ITestNGMethod[] methodsThatBelongToGroup;
            for (ITestNGMethod method : methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m1, methods, group)) {
                if (!method.equals(m22)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean equalsEffectiveClass(ITestNGMethod m1, ITestNGMethod m22) {
        try {
            Class c1 = m1.getRealClass();
            Class c2 = m22.getRealClass();
            return c1 == null ? c2 == null : c1.equals(c2);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void sortMethodsByInheritance(List<ITestNGMethod> methods, boolean baseClassToChild) {
        Collections.sort(methods);
        if (!baseClassToChild) {
            Collections.reverse(methods);
        }
    }
}

