/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import java.util.List;
import java.util.Properties;
import org.testng.ISuite;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.PropertiesFile;
import org.testng.internal.Utils;
import org.testng.remote.adapter.DefaultWorkerAdapter;
import org.testng.remote.adapter.IWorkerAdapter;
import org.testng.xml.XmlSuite;

public class SuiteSlave {
    public static final String VERBOSE = "testng.verbose";
    public static final String SLAVE_ADPATER = "testng.slave.adpter";
    private final int m_verbose;
    private final IWorkerAdapter m_slaveAdpter;
    private final TestNG m_testng;

    public SuiteSlave(String propertiesFile, TestNG testng) throws TestNGException {
        try {
            this.m_testng = testng;
            PropertiesFile file = new PropertiesFile(propertiesFile);
            Properties properties = file.getProperties();
            this.m_verbose = Integer.parseInt(properties.getProperty(VERBOSE, "1"));
            String adapter = properties.getProperty(SLAVE_ADPATER);
            if (adapter == null) {
                this.m_slaveAdpter = new DefaultWorkerAdapter();
            } else {
                Class<?> clazz = Class.forName(adapter);
                this.m_slaveAdpter = (IWorkerAdapter)clazz.newInstance();
            }
            this.m_slaveAdpter.init(properties);
        }
        catch (Exception e) {
            throw new TestNGException("Fail to initialize slave mode", e);
        }
    }

    public void waitForSuites() {
        try {
            while (true) {
                XmlSuite s2;
                if ((s2 = this.m_slaveAdpter.getSuite(Long.MAX_VALUE)) == null) {
                    continue;
                }
                SuiteSlave.log("Processing " + s2.getName());
                List<XmlSuite> suites = Lists.newArrayList();
                suites.add(s2);
                this.m_testng.setXmlSuites(suites);
                List<ISuite> suiteRunners = this.m_testng.runSuitesLocally();
                ISuite sr = suiteRunners.get(0);
                SuiteSlave.log("Done processing " + s2.getName());
                this.m_slaveAdpter.returnResult(sr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return;
        }
    }

    private static void log(String string) {
        Utils.log("", 2, string);
    }
}

