/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.AlterSuiteParametersListener;
import com.occamlab.te.spi.executors.testng.EarlReporter;
import com.occamlab.te.spi.util.HtmlReport;
import com.occamlab.te.spi.util.TestRunUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.jena.rdf.model.Model;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestNGExecutor
implements TestRunExecutor {
    private static final Logger LOGR = Logger.getLogger(TestNGExecutor.class.getPackage().getName());
    private static final List<String> SUPPORTED_MEDIA_TYPES = Arrays.asList("application/xml", "application/zip", "application/rdf+xml");
    private final boolean useDefaultListeners;
    private File outputDir;
    private URI testngConfig;

    public TestNGExecutor(String testngSuite) {
        this(testngSuite, System.getProperty("java.io.tmpdir"), false);
    }

    public TestNGExecutor(String testngSuite, String outputDirPath, boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        this.outputDir = new File(outputDirPath, "testng");
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            LOGR.config("Failed to create output directory at " + this.outputDir);
            this.outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (null != testngSuite && !testngSuite.isEmpty()) {
            this.testngConfig = URI.create(testngSuite);
        }
    }

    @Override
    public Source execute(Document testRunArgs) {
        if (null == testRunArgs) {
            throw new IllegalArgumentException("No test run arguments were supplied.");
        }
        String runId = null;
        String sourcesId = "";
        Map<String, String> argsMap = this.extractTestRunArguments(testRunArgs);
        if (argsMap.containsKey("logDir")) {
            this.outputDir = new File(argsMap.get("logDir"));
        }
        if (argsMap.containsKey("sourcesId")) {
            sourcesId = argsMap.get("sourcesId");
        }
        if (argsMap.containsKey("sessionId")) {
            runId = argsMap.get("sessionId");
            TestRunUtils.save(this.outputDir, runId, sourcesId);
        } else {
            runId = UUID.randomUUID().toString();
        }
        TestNG driver = new TestNG();
        this.setTestSuites(driver, this.testngConfig);
        driver.setVerbose(0);
        driver.setUseDefaultListeners(this.useDefaultListeners);
        File runDir = new File(this.outputDir, runId);
        if (!runDir.exists() && !runDir.mkdir()) {
            runDir = this.outputDir;
            LOGR.config("Created test run directory at " + runDir.getAbsolutePath());
        }
        driver.setOutputDirectory(runDir.getAbsolutePath());
        AlterSuiteParametersListener listener = new AlterSuiteParametersListener();
        listener.setTestRunArgs(testRunArgs);
        listener.setTestRunId(runId);
        driver.addListener(listener);
        try {
            driver.run();
        }
        catch (Exception e) {
            XmlSuite suite = new XmlSuite();
            suite.setSuiteFiles(Arrays.asList(this.testngConfig.toString()));
            suite.setParameters(argsMap);
            EarlReporter earlReporter = new EarlReporter();
            Model model = earlReporter.initializeModel(suite);
            earlReporter.addTestInputs(model, argsMap);
            earlReporter.addTopLevelFailure(model, e.getMessage());
            try {
                earlReporter.writeModel(model, runDir, true);
            }
            catch (IOException e1) {
                LOGR.log(Level.SEVERE, "Error writing default model: " + e.getMessage());
            }
            LOGR.log(Level.SEVERE, "Error while running: " + e.getMessage());
            throw e;
        }
        SAXSource source = null;
        try {
            File resultsFile = this.getResultsFile(this.getPreferredMediaType(testRunArgs), driver.getOutputDirectory());
            FileInputStream inStream = new FileInputStream(resultsFile);
            InputSource inSource = new InputSource(new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8));
            source = new SAXSource(inSource);
            source.setSystemId(resultsFile.toURI().toString());
        }
        catch (IOException e) {
            LOGR.log(Level.SEVERE, "Error reading test results: " + e.getMessage());
        }
        return source;
    }

    File getResultsFile(String mediaType, String outputDirectory) throws FileNotFoundException {
        String contentType = mediaType.split(";")[0];
        String fileName = null;
        if (contentType.endsWith("rdf+xml") || contentType.endsWith("rdf+earl")) {
            fileName = "earl-results.rdf";
        } else if (contentType.endsWith("zip")) {
            File htmlResult = HtmlReport.getHtmlResultZip(outputDirectory);
            fileName = "result.zip";
        } else {
            fileName = "testng-results.xml";
        }
        File resultsFile = new File(outputDirectory, fileName);
        if (!resultsFile.exists()) {
            throw new FileNotFoundException("Test run results not found at " + resultsFile.getAbsolutePath());
        }
        return resultsFile;
    }

    String getPreferredMediaType(Document testRunArgs) {
        String mediaTypeFromTestRunArg = this.parseMediaTypeFromTestRunArgs(testRunArgs);
        if (mediaTypeFromTestRunArg != null && SUPPORTED_MEDIA_TYPES.contains(mediaTypeFromTestRunArg)) {
            return mediaTypeFromTestRunArg;
        }
        return "application/xml";
    }

    private void setTestSuites(TestNG driver, URI ets) {
        if (ets.getScheme().equalsIgnoreCase("jar")) {
            String[] jarPath = ets.getSchemeSpecificPart().split("!");
            File jarFile = new File(URI.create(jarPath[0]));
            driver.setTestJar(jarFile.getAbsolutePath());
            driver.setXmlPathInJar(jarPath[1].substring(1));
        } else {
            ArrayList<String> testSuites = new ArrayList<String>();
            File tngFile = new File(ets);
            if (!tngFile.exists()) {
                throw new IllegalArgumentException("A valid TestNG config file reference is required.");
            }
            LOGR.log(Level.CONFIG, "Using TestNG config file {0}", tngFile.getAbsolutePath());
            testSuites.add(tngFile.getAbsolutePath());
            driver.setTestSuites(testSuites);
        }
    }

    private String parseMediaTypeFromTestRunArgs(Document testRunArgs) {
        NodeList entries = testRunArgs.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            if (!entry.getAttribute("key").equals("acceptMediaType")) continue;
            return entry.getTextContent().trim();
        }
        return null;
    }

    Map<String, String> extractTestRunArguments(Document testRunArgs) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        if (null != testRunArgs) {
            NodeList entries = testRunArgs.getElementsByTagName("entry");
            for (int i = 0; i < entries.getLength(); ++i) {
                Element entry = (Element)entries.item(i);
                argsMap.put(entry.getAttribute("key"), entry.getTextContent().trim());
            }
        }
        return argsMap;
    }
}

