/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TimedTraceListener;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Transform {
    protected TransformerFactoryImpl factory;
    protected Configuration config;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    String sourceParserName = null;

    public static void main(String[] args) throws Exception {
        new Transform().doTransform(args, "java net.sf.saxon.Transform");
    }

    public void setFactoryConfiguration(boolean schemaAware, String className) throws RuntimeException {
        if (schemaAware) {
            this.config = Configuration.makeSchemaAwareConfiguration(null, className);
        } else {
            this.config = new Configuration();
            this.config.setAllNodesUntyped(true);
        }
        this.factory = new TransformerFactoryImpl(this.config);
    }

    public void doTransform(String[] args, String command) {
        block162: {
            String sourceFileName = null;
            String styleFileName = null;
            File outputFile = null;
            ArrayList<String> parameterList = new ArrayList<String>(20);
            String outputFileName = null;
            String initialMode = null;
            String initialTemplate = null;
            boolean useAssociatedStylesheet = false;
            boolean wholeDirectory = false;
            boolean precompiled = false;
            boolean dtdValidation = false;
            String styleParserName = null;
            boolean explain = false;
            String explainOutputFileName = null;
            boolean schemaAware = false;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-sa") && !args[i].startsWith("-sa:") && !args[i].startsWith("-val:") && !args[i].equals("-val") && !args[i].equals("-vlax") && !args[i].equals("-p")) continue;
                schemaAware = true;
                break;
            }
            try {
                this.setFactoryConfiguration(schemaAware, null);
            }
            catch (Exception err) {
                err.printStackTrace();
                Transform.quit(err.getMessage(), 2);
            }
            this.config = this.factory.getConfiguration();
            schemaAware = this.config.isSchemaAware(50);
            try {
                int i = 0;
                while (i < args.length && args[i].charAt(0) == '-') {
                    TraceListener traceListener;
                    String option;
                    String value = null;
                    int colon = args[i].indexOf(58);
                    if (colon > 0 && colon < args[i].length() - 1) {
                        option = args[i].substring(1, colon);
                        value = args[i].substring(colon + 1);
                    } else {
                        option = args[i].substring(1);
                    }
                    if (option.equals("a")) {
                        useAssociatedStylesheet = true;
                        ++i;
                        continue;
                    }
                    if (option.equals("c")) {
                        precompiled = true;
                        if (value != null) {
                            styleFileName = value;
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("cr")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No resolver after -cr");
                            }
                            value = args[i++];
                        }
                        Object resolver2 = this.config.getInstance(value, null);
                        this.factory.setAttribute("http://saxon.sf.net/feature/collection-uri-resolver", resolver2);
                        continue;
                    }
                    if (option.equals("ds")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(0));
                        ++i;
                        continue;
                    }
                    if (option.equals("dt")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(1));
                        ++i;
                        continue;
                    }
                    if (option.equals("dtd")) {
                        if (!"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-dtd option must be -dtd:on or -dtd:off");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/validation", "on".equals(value));
                        ++i;
                        continue;
                    }
                    if (option.equals("expand")) {
                        if (!"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-expand option must be 'on' or 'off'");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/expandAttributeDefaults", "on".equals(value));
                        ++i;
                        continue;
                    }
                    if (option.equals("explain")) {
                        explain = true;
                        explainOutputFileName = value;
                        this.factory.setAttribute("http://saxon.sf.net/feature/trace-optimizer-decisions", Boolean.TRUE);
                        ++i;
                        continue;
                    }
                    if (option.equals("ext")) {
                        if (!"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-ext option must be -ext:on or -ext:off");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", "on".equals(value));
                        ++i;
                        continue;
                    }
                    if (option.equals("im")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No initial mode after -im");
                            }
                            value = args[i++];
                        }
                        initialMode = value;
                        continue;
                    }
                    if (option.equals("it")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No initial template after -it");
                            }
                            value = args[i++];
                        }
                        initialTemplate = value;
                        continue;
                    }
                    if (option.equals("l")) {
                        if (value != null && !"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-l option must be -l:on or -l:off");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", !"off".equals(value));
                        ++i;
                        continue;
                    }
                    if (option.equals("m")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No message receiver class after -m");
                            }
                            value = args[i++];
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/messageEmitterClass", value);
                        continue;
                    }
                    if (option.equals("noext")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", false);
                        continue;
                    }
                    if (option.equals("novw")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/version-warning", false);
                        ++i;
                        continue;
                    }
                    if (option.equals("o")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No output file name after -o");
                            }
                            value = args[i++];
                        }
                        outputFileName = value;
                        continue;
                    }
                    if (option.equals("or")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No output resolver class after -or");
                            }
                            value = args[i++];
                        }
                        String orclass = value;
                        Object resolver3 = this.config.getInstance(orclass, null);
                        this.factory.setAttribute("http://saxon.sf.net/feature/outputURIResolver", resolver3);
                        continue;
                    }
                    if (option.equals("outval")) {
                        if (schemaAware) {
                            if (value != null && !"recover".equals(value) && !"fatal".equals(value)) {
                                this.badUsage(command, "-outval option must be 'recover' or 'fatal'");
                            }
                            this.factory.setAttribute("http://saxon.sf.net/feature/validation-warnings", "recover".equals(value));
                        } else {
                            Transform.quit("The -outval option requires a schema-aware processor", 2);
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("p")) {
                        ++i;
                        if (value != null && !"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-p option must be -p:on or -p:off");
                        }
                        if ("off".equals(value)) continue;
                        this.config.setParameterizedURIResolver();
                        this.useURLs = true;
                        continue;
                    }
                    if (option.equals("r")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No URIesolver class after -r");
                            }
                            value = args[i++];
                        }
                        this.factory.setURIResolver(this.config.makeURIResolver(value));
                        continue;
                    }
                    if (option.equals("repeat")) {
                        ++i;
                        if (value == null) {
                            this.badUsage(command, "No number after -repeat");
                            continue;
                        }
                        try {
                            this.repeat = Integer.parseInt(value);
                        }
                        catch (NumberFormatException err) {
                            this.badUsage(command, "Bad number after -repeat");
                        }
                        continue;
                    }
                    if (option.equals("s")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No source file name after -s");
                            }
                            value = args[i++];
                        }
                        sourceFileName = value;
                        continue;
                    }
                    if (option.equals("sa")) {
                        ++i;
                        continue;
                    }
                    if (option.equals("snone")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "none");
                        ++i;
                        continue;
                    }
                    if (option.equals("sall")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "all");
                        ++i;
                        continue;
                    }
                    if (option.equals("signorable")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "ignorable");
                        ++i;
                        continue;
                    }
                    if (option.equals("strip")) {
                        if ("none".equals(value) || "all".equals(value) || "ignorable".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", value);
                            ++i;
                            continue;
                        }
                        this.badUsage(command, "-strip must be none, all, or ignorable");
                        continue;
                    }
                    if (option.equals("t")) {
                        System.err.println(this.config.getProductTitle());
                        System.err.println(Configuration.getPlatform().getPlatformVersion());
                        this.factory.setAttribute("http://saxon.sf.net/feature/timing", true);
                        this.showTime = true;
                        ++i;
                        continue;
                    }
                    if (option.equals("T")) {
                        ++i;
                        traceListener = value == null ? new XSLTTraceListener() : this.config.makeTraceListener(value);
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", traceListener);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (option.equals("TJ")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/trace-external-functions", Boolean.TRUE);
                        continue;
                    }
                    if (option.equals("TL")) {
                        if (args.length < ++i + 2) {
                            this.badUsage(command, "No TraceListener class");
                        }
                        traceListener = this.config.makeTraceListener(args[i++]);
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", traceListener);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (option.equals("TP")) {
                        ++i;
                        traceListener = new TimedTraceListener();
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", traceListener);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (option.equals("tree")) {
                        if ("linked".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(0));
                        } else if ("tiny".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(1));
                        } else {
                            this.badUsage(command, "-tree option must be 'linked' or 'tiny'");
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("u")) {
                        this.useURLs = true;
                        ++i;
                        continue;
                    }
                    if (option.equals("v")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/validation", true);
                        dtdValidation = true;
                        ++i;
                        continue;
                    }
                    if (option.equals("val")) {
                        if (!schemaAware) {
                            this.badUsage(command, "The -val option requires a schema-aware processor");
                        } else if (value == null || "strict".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Integer(1));
                        } else if ("lax".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Integer(2));
                        } else {
                            this.badUsage(command, "-val option must be 'strict' or 'lax'");
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("vlax")) {
                        if (schemaAware) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Integer(2));
                        } else {
                            Transform.quit("The -vlax option requires a schema-aware processor", 2);
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("versionmsg")) {
                        if (!"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-versionmsg option must be -versionmsg:on or -versionmsg:off");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/version-warning", "on".equals(value));
                        ++i;
                        continue;
                    }
                    if (option.equals("vw")) {
                        if (schemaAware) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/validation-warnings", true);
                        } else {
                            Transform.quit("The -vw option requires a schema-aware processor", 2);
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("warnings")) {
                        if ("silent".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(0));
                        } else if ("recover".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(1));
                        } else if ("fatal".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(2));
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("w0")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(0));
                        continue;
                    }
                    if (option.equals("w1")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(1));
                        continue;
                    }
                    if (option.equals("w2")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(2));
                        continue;
                    }
                    if (option.equals("x")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No source parser class after -x");
                            }
                            value = args[i++];
                        }
                        this.sourceParserName = value;
                        this.factory.setAttribute("http://saxon.sf.net/feature/sourceParserClass", this.sourceParserName);
                        continue;
                    }
                    if (option.equals("xi")) {
                        if (value != null && !"on".equals(value) && !"off".equals(value)) {
                            this.badUsage(command, "-xi option must be -xi:on or -xi:off");
                        }
                        if (!"off".equals(value)) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/xinclude-aware", Boolean.TRUE);
                        }
                        ++i;
                        continue;
                    }
                    if (option.equals("xsl")) {
                        ++i;
                        styleFileName = value;
                        continue;
                    }
                    if (option.equals("y")) {
                        ++i;
                        if (value == null) {
                            if (args.length < i + 2) {
                                this.badUsage(command, "No stylesheet parser class after -y");
                            }
                            value = args[i++];
                        }
                        styleParserName = value;
                        this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", value);
                        continue;
                    }
                    if (option.equals("1.1")) {
                        ++i;
                        this.factory.setAttribute("http://saxon.sf.net/feature/xml-version", "1.1");
                        continue;
                    }
                    if (option.equals("xmlversion")) {
                        ++i;
                        if (!("1.0".equals(value) | "1.1".equals(value))) {
                            this.badUsage(command, "-xmlversion must be 1.0 or 1.1");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/xml-version", value);
                        continue;
                    }
                    if (args[i].equals("-?")) {
                        this.badUsage(command, "");
                        continue;
                    }
                    if (args[i].equals("-")) break;
                    this.badUsage(command, "Unknown option " + args[i]);
                }
                if (initialTemplate != null && useAssociatedStylesheet) {
                    this.badUsage(command, "-it and -a options cannot be used together");
                }
                if (initialTemplate == null && sourceFileName == null) {
                    if (args.length < i + 1) {
                        this.badUsage(command, "No source file name");
                    }
                    sourceFileName = args[i++];
                }
                if (!useAssociatedStylesheet && styleFileName == null) {
                    if (args.length < i + 1) {
                        this.badUsage(command, "No stylesheet file name");
                    }
                    styleFileName = args[i++];
                }
                for (int p = i; p < args.length; ++p) {
                    String arg = args[p];
                    int eq = arg.indexOf("=");
                    if (eq < 1 || eq >= arg.length()) {
                        this.badUsage(command, "Bad param=value pair on command line: " + arg);
                    }
                    parameterList.add(arg);
                }
                this.config.displayLicenseMessage();
                List<Object> sources = null;
                if (sourceFileName != null) {
                    boolean useSAXSource = this.sourceParserName != null || dtdValidation;
                    Object loaded = Transform.loadDocuments(sourceFileName, this.useURLs, this.config, useSAXSource);
                    if (loaded instanceof List) {
                        wholeDirectory = true;
                        sources = (List)loaded;
                    } else {
                        wholeDirectory = false;
                        sources = new ArrayList<Object>(1);
                        sources.add(loaded);
                    }
                    sources = this.preprocess(sources);
                    if (wholeDirectory) {
                        if (outputFileName == null) {
                            Transform.quit("To process a directory, -o must be specified", 2);
                        } else if (outputFileName.equals(sourceFileName)) {
                            Transform.quit("Output directory must be different from input", 2);
                        } else {
                            outputFile = new File(outputFileName);
                            if (!outputFile.isDirectory()) {
                                Transform.quit("Input is a directory, but output is not", 2);
                            }
                        }
                    }
                }
                if (outputFileName != null && !wholeDirectory && (outputFile = new File(outputFileName)).isDirectory()) {
                    Transform.quit("Output is a directory, but input is not", 2);
                }
                if (useAssociatedStylesheet) {
                    if (wholeDirectory) {
                        this.processDirectoryAssoc(sources, outputFile, parameterList, initialMode);
                    } else {
                        this.processFileAssoc((Source)sources.get(0), null, outputFile, parameterList, initialMode);
                    }
                    break block162;
                }
                long startTime = new Date().getTime();
                PreparedStylesheet sheet = null;
                if (precompiled) {
                    try {
                        sheet = PreparedStylesheet.loadCompiledStylesheet(this.config, styleFileName);
                        if (this.showTime) {
                            long endTime = new Date().getTime();
                            System.err.println("Stylesheet loading time: " + (endTime - startTime) + " milliseconds");
                        }
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                } else {
                    Source styleSource;
                    XMLReader styleParser = null;
                    if (this.useURLs || styleFileName.startsWith("http:") || styleFileName.startsWith("file:")) {
                        styleSource = this.config.getURIResolver().resolve(styleFileName, null);
                        if (styleSource == null) {
                            styleSource = this.config.getSystemURIResolver().resolve(styleFileName, null);
                        }
                    } else if (styleFileName.equals("-")) {
                        if (styleParserName == null) {
                            styleSource = new StreamSource(System.in);
                        } else if (Configuration.getPlatform().isJava()) {
                            styleParser = this.config.getStyleParser();
                            styleSource = new SAXSource(styleParser, new InputSource(System.in));
                        } else {
                            styleSource = new StreamSource(System.in);
                        }
                    } else {
                        File sheetFile = new File(styleFileName);
                        if (!sheetFile.exists()) {
                            Transform.quit("Stylesheet file " + sheetFile + " does not exist", 2);
                        }
                        if (styleParserName == null) {
                            styleSource = new StreamSource(sheetFile.toURI().toString());
                        } else {
                            InputSource eis = new InputSource(sheetFile.toURI().toString());
                            styleParser = this.config.getStyleParser();
                            styleSource = new SAXSource(styleParser, eis);
                        }
                    }
                    if (styleSource == null) {
                        Transform.quit("URIResolver for stylesheet file must return a Source", 2);
                    }
                    sheet = (PreparedStylesheet)this.factory.newTemplates(styleSource);
                    if (styleParser != null) {
                        this.config.reuseStyleParser(styleParser);
                    }
                    if (this.showTime) {
                        long endTime = Transform.now();
                        System.err.println("Stylesheet compilation time: " + (endTime - startTime) + " milliseconds");
                    }
                    if (explain) {
                        OutputStream explainOutput = explainOutputFileName == null ? System.err : new FileOutputStream(new File(explainOutputFileName));
                        Properties props = new Properties();
                        props.setProperty("method", "xml");
                        props.setProperty("indent", "yes");
                        props.setProperty("{http://saxon.sf.net/}indent-spaces", "2");
                        Receiver diag = this.config.getSerializerFactory().getReceiver(new StreamResult(explainOutput), this.config.makePipelineConfiguration(), props);
                        ExpressionPresenter expressionPresenter = new ExpressionPresenter(this.config, diag);
                        sheet.explain(expressionPresenter);
                        expressionPresenter.close();
                    }
                }
                if (wholeDirectory) {
                    this.processDirectory(sources, sheet, outputFile, parameterList, initialTemplate, initialMode);
                } else {
                    Source source = sources == null ? null : (Source)sources.get(0);
                    this.processFile(source, sheet, outputFile, parameterList, initialTemplate, initialMode);
                }
            }
            catch (TerminationException err) {
                Transform.quit(err.getMessage(), 1);
            }
            catch (TransformerConfigurationException err) {
                Transform.quit(err.getMessage(), 2);
            }
            catch (TransformerException err) {
                Transform.quit("Transformation failed: " + err.getMessage(), 2);
            }
            catch (TransformerFactoryConfigurationError err) {
                Transform.quit("Transformation failed: " + err.getMessage(), 2);
            }
            catch (Exception err2) {
                err2.printStackTrace();
                Transform.quit("Fatal error during transformation: " + err2.getClass().getName() + ": " + (err2.getMessage() == null ? " (no message)" : err2.getMessage()), 2);
            }
        }
    }

    public List preprocess(List sources) throws XPathException {
        return sources;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    public static Object loadDocuments(String sourceFileName, boolean useURLs, Configuration config, boolean useSAXSource) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            Source sourceInput2 = config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput2 == null) {
                sourceInput2 = config.getSystemURIResolver().resolve(sourceFileName, null);
            }
            return sourceInput2;
        }
        if (sourceFileName.equals("-")) {
            Source sourceInput3;
            if (useSAXSource) {
                XMLReader parser = config.getSourceParser();
                sourceInput3 = new SAXSource(parser, new InputSource(System.in));
            } else {
                sourceInput3 = new StreamSource(System.in);
            }
            return sourceInput3;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            Transform.quit("Source file " + sourceFile + " does not exist", 2);
        }
        if (sourceFile.isDirectory()) {
            XMLReader parser = config.getSourceParser();
            ArrayList<StreamSource> result = new ArrayList<StreamSource>(20);
            String[] files = sourceFile.list();
            for (int f = 0; f < files.length; ++f) {
                Source sourceInput4;
                File file = new File(sourceFile, files[f]);
                if (file.isDirectory()) continue;
                if (useSAXSource) {
                    InputSource eis = new InputSource(file.toURI().toString());
                    sourceInput4 = new SAXSource(parser, eis);
                } else {
                    sourceInput4 = new StreamSource(file.toURI().toString());
                }
                result.add((StreamSource)sourceInput4);
            }
            return result;
        }
        if (useSAXSource) {
            InputSource eis = new InputSource(sourceFile.toURI().toString());
            sourceInput = new SAXSource(config.getSourceParser(), eis);
        } else {
            sourceInput = new StreamSource(sourceFile.toURI().toString());
        }
        return sourceInput;
    }

    public void processDirectoryAssoc(List sources, File outputDir, ArrayList parameterList, String initialMode) throws Exception {
        int failures = 0;
        for (int f = 0; f < sources.size(); ++f) {
            Source source = (Source)sources.get(f);
            String localName = Transform.getLocalFileName(source);
            try {
                this.processFileAssoc(source, localName, outputDir, parameterList, initialMode);
                continue;
            }
            catch (XPathException err) {
                ++failures;
                System.err.println("While processing " + localName + ": " + err.getMessage() + '\n');
            }
        }
        if (failures > 0) {
            throw new XPathException(failures + " transformation" + (failures == 1 ? "" : "s") + " failed");
        }
    }

    private File makeOutputFile(File directory, String localName, Templates sheet) {
        String mediaType = sheet.getOutputProperties().getProperty("media-type");
        String suffix = ".xml";
        if ("text/html".equals(mediaType)) {
            suffix = ".html";
        } else if ("text/plain".equals(mediaType)) {
            suffix = ".txt";
        }
        String prefix = localName;
        if (localName.endsWith(".xml") || localName.endsWith(".XML")) {
            prefix = localName.substring(0, localName.length() - 4);
        }
        return new File(directory, prefix + suffix);
    }

    public void processFileAssoc(Source sourceInput, String localName, File outputFile, ArrayList parameterList, String initialMode) throws TransformerException {
        File outFile;
        if (this.showTime) {
            System.err.println("Processing " + sourceInput.getSystemId() + " using associated stylesheet");
        }
        long startTime = Transform.now();
        Source style = this.factory.getAssociatedStylesheet(sourceInput, null, null, null);
        Templates sheet = this.factory.newTemplates(style);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + style.getSystemId());
        }
        Transformer instance = sheet.newTransformer();
        this.setParams(instance, parameterList);
        if (initialMode != null) {
            ((Controller)instance).setInitialMode(initialMode);
        }
        if ((outFile = outputFile) != null && outFile.isDirectory()) {
            outFile = this.makeOutputFile(outFile, localName, sheet);
        }
        StreamResult result = outFile == null ? new StreamResult(System.out) : new StreamResult(outFile.toURI().toString());
        try {
            instance.transform(sourceInput, result);
        }
        catch (TerminationException err) {
            throw err;
        }
        catch (XPathException err) {
            throw new XPathException("Run-time errors were reported");
        }
        if (this.showTime) {
            long endTime = Transform.now();
            System.err.println("Execution time: " + (endTime - startTime) + " milliseconds");
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public void processDirectory(List sources, Templates sheet, File outputDir, ArrayList parameterList, String initialTemplate, String initialMode) throws TransformerException {
        int failures = 0;
        for (int f = 0; f < sources.size(); ++f) {
            Source source = (Source)sources.get(f);
            String localName = Transform.getLocalFileName(source);
            try {
                File outputFile = this.makeOutputFile(outputDir, localName, sheet);
                this.processFile(source, sheet, outputFile, parameterList, initialTemplate, initialMode);
                continue;
            }
            catch (XPathException err) {
                ++failures;
                System.err.println("While processing " + localName + ": " + err.getMessage() + '\n');
            }
        }
        if (failures > 0) {
            throw new XPathException(failures + " transformation" + (failures == 1 ? "" : "s") + " failed");
        }
    }

    private static String getLocalFileName(Source source) {
        try {
            String path = new URI(source.getSystemId()).getPath();
            while (true) {
                int sep;
                if ((sep = path.indexOf(47)) < 0) {
                    return path;
                }
                path = path.substring(sep + 1);
            }
        }
        catch (URISyntaxException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
    }

    public void processFile(Source source, Templates sheet, File outputFile, ArrayList parameterList, String initialTemplate, String initialMode) throws TransformerException {
        long totalTime = 0L;
        int runs = 0;
        for (int r = 0; r < this.repeat; ++r) {
            if (this.showTime) {
                String msg = "Processing ";
                msg = source != null ? msg + source.getSystemId() : msg + " (no source document)";
                if (initialMode != null) {
                    msg = msg + " initial mode = " + initialMode;
                }
                if (initialTemplate != null) {
                    msg = msg + " initial template = " + initialTemplate;
                }
                System.err.println(msg);
            }
            long startTime = Transform.now();
            ++runs;
            Transformer instance = sheet.newTransformer();
            this.setParams(instance, parameterList);
            if (initialMode != null) {
                ((Controller)instance).setInitialMode(initialMode);
            }
            if (initialTemplate != null) {
                ((Controller)instance).setInitialTemplate(initialTemplate);
            }
            StreamResult result = outputFile == null ? new StreamResult(System.out) : new StreamResult(outputFile.toURI().toString());
            try {
                instance.transform(source, result);
            }
            catch (TerminationException err) {
                throw err;
            }
            catch (XPathException err) {
                if (!err.hasBeenReported()) {
                    err.printStackTrace();
                }
                throw new XPathException("Run-time errors were reported");
            }
            long endTime = Transform.now();
            totalTime += endTime - startTime;
            if (this.showTime) {
                System.err.println("Execution time: " + (endTime - startTime) + " milliseconds");
                System.err.println("Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                this.config.getNamePool().statistics();
                if (this.repeat > 1) {
                    System.err.println("-------------------------------");
                    Runtime.getRuntime().gc();
                }
            }
            if (this.repeat == 999999 && totalTime > 60000L) break;
        }
        if (this.repeat > 1) {
            System.err.println("*** Average execution time over " + runs + " runs: " + totalTime / (long)runs + "ms");
        }
    }

    private void setParams(Transformer t2, ArrayList parameterList) throws TransformerException {
        for (int i = 0; i < parameterList.size(); ++i) {
            String argvalue;
            String arg = (String)parameterList.get(i);
            int eq = arg.indexOf("=");
            String argname = arg.substring(0, eq);
            String string = argvalue = eq == arg.length() - 1 ? "" : arg.substring(eq + 1);
            if (argname.startsWith("!")) {
                t2.setOutputProperty(argname.substring(1), argvalue);
                continue;
            }
            if (argname.startsWith("+")) {
                Object sources = Transform.loadDocuments(argvalue, this.useURLs, this.config, true);
                t2.setParameter(argname.substring(1), sources);
                continue;
            }
            t2.setParameter(argname, new UntypedAtomicValue(argvalue));
        }
    }

    protected void badUsage(String name, String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/using-xsl/commandline.html");
        System.err.println("Options: ");
        System.err.println("  -a                    Use xml-stylesheet PI, not style-doc argument");
        System.err.println("  -c:filename           Use compiled stylesheet from file");
        System.err.println("  -cr:classname         Use collection URI resolver class");
        System.err.println("  -dtd:on|off           Validate using DTD");
        System.err.println("  -expand:on|off        Expand defaults defined in schema/DTD");
        System.err.println("  -explain[:filename]   Display compiled expression tree");
        System.err.println("  -ext:on|off           Allow|Disallow external Java functions");
        System.err.println("  -im:modename          Initial mode");
        System.err.println("  -it:template          Initial template");
        System.err.println("  -l:on|off             Line numbering for source document");
        System.err.println("  -m:classname          Use message receiver class");
        System.err.println("  -o:filename           Output file or directory");
        System.err.println("  -or:classname         Use OutputURIResolver class");
        System.err.println("  -outval:recover|fatal Handling of validation errors on result document");
        System.err.println("  -p:on|off             Recognize URI query parameters");
        System.err.println("  -r:classname          Use URIResolver class");
        System.err.println("  -repeat:N             Repeat N times for performance measurement");
        System.err.println("  -s:filename           Initial source document");
        System.err.println("  -sa                   Schema-aware transformation");
        System.err.println("  -strip:all|none|ignorable      Strip whitespace text nodes");
        System.err.println("  -t                    Display version and timing information");
        System.err.println("  -T[:classname]        Use TraceListener class");
        System.err.println("  -TJ                   Trace calls to external Java functions");
        System.err.println("  -tree:tiny|linked     Select tree model");
        System.err.println("  -u                    Names are URLs not filenames");
        System.err.println("  -val:strict|lax       Validate using schema");
        System.err.println("  -versionmsg:on|off    Warn when using XSLT 1.0 stylesheet");
        System.err.println("  -warnings:silent|recover|fatal  Handling of recoverable errors");
        System.err.println("  -x:classname          Use specified SAX parser for source file");
        System.err.println("  -xi:on|off            Expand XInclude on all documents");
        System.err.println("  -xmlversion:1.0|1.1   Version of XML to be handled");
        System.err.println("  -xsl:filename         Stylesheet file");
        System.err.println("  -y:classname          Use specified SAX parser for stylesheet");
        System.err.println("  -?                    Display this message ");
        System.err.println("  param=value           Set stylesheet string parameter");
        System.err.println("  +param=filename       Set stylesheet document parameter");
        System.err.println("  !option=value         Set serialization option");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

