/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NumericPromoter;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class TypeChecker {
    private TypeChecker() {
    }

    public static Expression staticTypeCheck(Expression supplied, SequenceType req, boolean backwardsCompatible, RoleLocator role, ExpressionVisitor visitor) throws XPathException {
        XPathException err;
        Expression cexp;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        if (supplied.implementsStaticTypeCheck()) {
            return supplied.staticTypeCheck(req, backwardsCompatible, role, visitor);
        }
        Expression exp = supplied;
        StaticContext env = visitor.getStaticContext();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        boolean allowsMany = Cardinality.allowsMany(reqCard);
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = reqItemType instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType(th);
            if (suppliedItemType instanceof EmptySequenceTest) {
                itemTypeOK = true;
            } else {
                if (reqItemType == null || suppliedItemType == null) {
                    throw new NullPointerException();
                }
                relation = th.relationship(reqItemType, suppliedItemType);
                boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
            }
        }
        if (backwardsCompatible && !allowsMany) {
            if (Cardinality.allowsMany(suppliedCard)) {
                FirstItemExpression cexp2 = new FirstItemExpression(exp);
                cexp2.adoptChildExpression(exp);
                exp = cexp2;
                suppliedCard = 24576;
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
            if (!itemTypeOK) {
                if (reqItemType.equals(BuiltInAtomicType.STRING)) {
                    StringFn fn = (StringFn)SystemFunction.makeSystemFunction("string", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), AnyItemType.getInstance());
                    }
                    catch (XPathException err2) {
                        err2.maybeSetLocation(exp);
                        throw err2.makeStatic();
                    }
                    suppliedItemType = BuiltInAtomicType.STRING;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
                if (reqItemType.equals(BuiltInAtomicType.NUMERIC) || reqItemType.equals(BuiltInAtomicType.DOUBLE)) {
                    NumberFn fn = (NumberFn)SystemFunction.makeSystemFunction("number", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), AnyItemType.getInstance());
                    }
                    catch (XPathException err3) {
                        err3.maybeSetLocation(exp);
                        throw err3.makeStatic();
                    }
                    suppliedItemType = BuiltInAtomicType.DOUBLE;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
            }
        }
        if (!itemTypeOK && reqItemType.isAtomicType()) {
            int rt;
            if (!suppliedItemType.isAtomicType() && suppliedCard != 8192) {
                Expression cexp3 = new Atomizer(exp, env.getConfiguration()).simplify(visitor);
                ExpressionTool.copyLocationInfo(exp, cexp3);
                exp = cexp3;
                suppliedItemType = exp.getItemType(th);
                suppliedCard = exp.getCardinality();
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
            if (suppliedItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                UntypedAtomicConverter cexp4 = new UntypedAtomicConverter(exp, (AtomicType)reqItemType, true);
                ExpressionTool.copyLocationInfo(exp, cexp4);
                try {
                    exp = exp instanceof Literal ? Literal.makeLiteral(new SequenceExtent(((Expression)cexp4).iterate(env.makeEarlyEvaluationContext())).simplify()) : cexp4;
                }
                catch (XPathException err4) {
                    err4.maybeSetLocation(exp);
                    throw err4.makeStatic();
                }
                itemTypeOK = true;
                suppliedItemType = reqItemType;
            }
            if (suppliedItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                UntypedAtomicConverter cexp5 = new UntypedAtomicConverter(exp, (AtomicType)reqItemType, false);
                ExpressionTool.copyLocationInfo(exp, cexp5);
                try {
                    exp = exp instanceof Literal ? Literal.makeLiteral(new SequenceExtent(((Expression)cexp5).iterate(env.makeEarlyEvaluationContext())).simplify()) : cexp5;
                    suppliedItemType = exp.getItemType(th);
                }
                catch (XPathException err5) {
                    err5.maybeSetLocation(exp);
                    throw err5.makeStatic();
                }
            }
            if (((rt = ((AtomicType)reqItemType).getFingerprint()) == 517 || rt == 516) && th.relationship(suppliedItemType, BuiltInAtomicType.NUMERIC) != 4) {
                cexp = new NumericPromoter(exp, (BuiltInAtomicType)reqItemType.getPrimitiveItemType());
                ExpressionTool.copyLocationInfo(exp, cexp);
                exp = cexp;
                try {
                    exp = visitor.typeCheck(visitor.simplify(exp), AnyItemType.getInstance());
                }
                catch (XPathException err6) {
                    err6.maybeSetLocation(exp);
                    throw err6.makeStatic();
                }
                suppliedItemType = rt == 517 ? BuiltInAtomicType.DOUBLE : BuiltInAtomicType.FLOAT;
                suppliedCard = -1;
            }
            if (rt == 513 && th.isSubType(suppliedItemType, BuiltInAtomicType.ANY_URI)) {
                suppliedItemType = BuiltInAtomicType.STRING;
                itemTypeOK = true;
            }
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err7 = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err7.setErrorCode(role.getErrorCode());
            err7.setIsTypeError(true);
            throw err7;
        }
        int n = relation = itemTypeOK ? 2 : th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, supplied);
                }
            } else {
                err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(role.getSourceLocator());
                throw err;
            }
        }
        if (relation != 0 && relation != 2) {
            if (exp instanceof Literal) {
                err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(role.getSourceLocator());
                throw err;
            }
            cexp = new ItemChecker(exp, reqItemType, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(true);
                err.setErrorCode(role.getErrorCode());
                err.setLocator(role.getSourceLocator());
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        return exp;
    }

    public static Expression strictTypeCheck(Expression supplied, SequenceType req, RoleLocator role, StaticContext env) throws XPathException {
        Expression cexp;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        Expression exp = supplied;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = req.getPrimaryType() instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType(th);
            relation = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = suppliedItemType instanceof EmptySequenceTest ? 8192 : exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedItemType == null) {
            suppliedItemType = exp.getItemType(th);
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(true);
            err.setLocator(role.getSourceLocator());
            throw err;
        }
        relation = th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, supplied);
                }
            } else {
                XPathException err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(role.getSourceLocator());
                throw err;
            }
        }
        if (relation != 0 && relation != 2) {
            cexp = new ItemChecker(exp, reqItemType, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                XPathException err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(true);
                err.setErrorCode(role.getErrorCode());
                err.setLocator(role.getSourceLocator());
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        return exp;
    }

    public static XPathException testConformance(ValueRepresentation val, SequenceType requiredType, XPathContext context) throws XPathException {
        Item item;
        ItemType reqItemType = requiredType.getPrimaryType();
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        SequenceIterator iter = Value.asIterator(val);
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (reqItemType.matchesItem(item, false, config)) continue;
            XPathException err = new XPathException("Required type is " + reqItemType + "; supplied value has type " + Value.asValue(val).getItemType(th));
            err.setIsTypeError(true);
            return err;
        }
        int reqCardinality = requiredType.getCardinality();
        if (count == 0 && !Cardinality.allowsZero(reqCardinality)) {
            XPathException err = new XPathException("Required type does not allow empty sequence, but supplied value is empty");
            err.setIsTypeError(true);
            return err;
        }
        if (count > 1 && !Cardinality.allowsMany(reqCardinality)) {
            XPathException err = new XPathException("Required type requires a singleton sequence; supplied value contains " + count + " items");
            err.setIsTypeError(true);
            return err;
        }
        if (count > 0 && reqCardinality == 8192) {
            XPathException err = new XPathException("Required type requires an empty sequence, but supplied value is non-empty");
            err.setIsTypeError(true);
            return err;
        }
        return null;
    }

    public static XPathException ebvError(Expression exp, TypeHierarchy th) {
        if (Cardinality.allowsZero(exp.getCardinality())) {
            return null;
        }
        ItemType t2 = exp.getItemType(th);
        if (th.relationship(t2, Type.NODE_TYPE) == 4 && th.relationship(t2, BuiltInAtomicType.BOOLEAN) == 4 && th.relationship(t2, BuiltInAtomicType.STRING) == 4 && th.relationship(t2, BuiltInAtomicType.ANY_URI) == 4 && th.relationship(t2, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(t2, BuiltInAtomicType.NUMERIC) == 4 && !(t2 instanceof ExternalObjectType)) {
            XPathException err = new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            err.setErrorCode("FORG0006");
            err.setIsTypeError(true);
            return err;
        }
        return null;
    }
}

