/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.util.Objects;
import java.util.Optional;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.RelativeIRIException;

public class IRIxResolver {
    private final IRIx base;
    private final boolean resolve;
    private final boolean allowRelative;
    private static int DftCacheSize = 500;
    private Cache<String, IRIx> cache = CacheFactory.createCache(DftCacheSize);

    private IRIxResolver(IRIx base, boolean resolve, boolean allowRelative) {
        this.base = base;
        this.resolve = resolve;
        this.allowRelative = allowRelative;
    }

    public IRIx getBase() {
        return this.base;
    }

    public String getBaseURI() {
        return this.base == null ? null : this.base.str();
    }

    public IRIx resolve(String other) {
        Objects.requireNonNull(other);
        if (this.cache == null) {
            return this.resolve0(other);
        }
        IRIx iri = this.cache.getIfPresent(other);
        if (iri != null) {
            return iri;
        }
        IRIx iriValue = this.resolve0(other);
        return this.cache.get(other, k -> iriValue);
    }

    private IRIx resolve0(String str) {
        IRIx x;
        IRIx iRIx = x = this.base != null && this.resolve ? this.base.resolve(str) : IRIx.create(str);
        if (!this.allowRelative && x.isRelative()) {
            throw new RelativeIRIException("Relative IRI: <" + str + ">");
        }
        return x;
    }

    public IRIxResolver resetBase(IRIx newBase) {
        return new IRIxResolver(newBase, this.resolve, this.allowRelative);
    }

    public String toString() {
        return "IRIxResolver[base=" + this.base + ", resolve=" + this.resolve + ", relative=" + this.allowRelative + "]";
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(IRIxResolver original) {
        Builder builder = new Builder();
        builder.base = Optional.ofNullable(original.base);
        builder.resolve = original.resolve;
        builder.allowRelative = original.allowRelative;
        return builder;
    }

    public static Builder create(IRIx baseIRI) {
        return new Builder().base(baseIRI);
    }

    public static Builder create(String baseStr) {
        IRIx base = baseStr == null ? null : IRIs.resolveIRI(baseStr);
        return new Builder().base(base);
    }

    public static class Builder {
        private Optional<IRIx> base = null;
        private boolean resolve = true;
        private boolean allowRelative = true;

        private Builder() {
        }

        public Builder base(IRIx baseURI) {
            this.base = Optional.ofNullable(baseURI);
            return this;
        }

        public Builder base(String baseStr) {
            IRIx baseIRI = baseStr == null ? null : IRIs.resolveIRI(baseStr);
            this.base = Optional.ofNullable(baseIRI);
            return this;
        }

        public Builder noBase() {
            this.base = Optional.empty();
            return this;
        }

        public Builder resolve(boolean resolveURIs) {
            this.resolve = resolveURIs;
            return this;
        }

        public Builder allowRelative(boolean allowRelative) {
            this.allowRelative = allowRelative;
            return this;
        }

        public IRIxResolver build() {
            if (this.base == null) {
                throw new IRIException("Base has not been set");
            }
            IRIx baseIRI = this.base.orElse(null);
            return new IRIxResolver(baseIRI, this.resolve, this.allowRelative);
        }
    }
}

