/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.ArrayList;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.OntPropertyImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class ObjectPropertyImpl
extends OntPropertyImpl
implements ObjectProperty {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new ObjectPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to ObjectProperty");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, ObjectProperty.class);
        }
    };

    public ObjectPropertyImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public OntProperty getInverseOf() {
        OntProperty inv = super.getInverseOf();
        return inv == null ? null : inv.asObjectProperty();
    }

    @Override
    public ExtendedIterator<? extends OntProperty> listInverseOf() {
        ArrayList<OntProperty> objPs = new ArrayList<OntProperty>();
        ExtendedIterator<? extends OntProperty> i = super.listInverseOf();
        while (i.hasNext()) {
            objPs.add(((OntProperty)i.next()).as(ObjectProperty.class));
        }
        return WrappedIterator.create(objPs.iterator());
    }

    @Override
    public OntProperty getInverse() {
        OntProperty inv = super.getInverse();
        return inv != null ? inv.asObjectProperty() : null;
    }
}

