/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpatialReferenceSystemsTests
extends CommonFixture {
    @Test(description="See OGC 12-128r12: Requirement 10")
    public void srsTableDefinition() throws SQLException {
        String tableName = "gpkg_spatial_ref_sys";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_spatial_ref_sys');");){
            int passFlag = 0;
            int flagMask = 63;
            this.checkPrimaryKey("gpkg_spatial_ref_sys", "srs_id", true);
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("srs_id".equals(name)) {
                    passFlag |= 1;
                    continue;
                }
                if ("srs_name".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("InvalidColumnDefinition", "srs_name", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("InvalidColumnDefinition", "srs_name", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 2;
                    continue;
                }
                if ("organization".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("InvalidColumnDefinition", "organization", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("InvalidColumnDefinition", "organization", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 4;
                    continue;
                }
                if ("organization_coordsys_id".equals(name)) {
                    Assert.assertTrue("INTEGER".equals(resultSet.getString("type")), ErrorMessage.format("InvalidColumnDefinition", "organization_coordsys_id", "gpkg_spatial_ref_sys", "type", "INTEGER", resultSet.getString("type")));
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("InvalidColumnDefinition", "organization_coordsys_id", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 8;
                    continue;
                }
                if ("definition".equals(name)) {
                    Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("InvalidColumnDefinition", "definition", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue(resultSet.getInt("notnull") == 1, ErrorMessage.format("InvalidColumnDefinition", "definition", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getString("notnull")));
                    passFlag |= 0x10;
                    continue;
                }
                if (!"description".equals(name)) continue;
                Assert.assertTrue("TEXT".equals(resultSet.getString("type")), ErrorMessage.format("InvalidColumnDefinition", "description", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                Assert.assertTrue(resultSet.getInt("notnull") == 0, ErrorMessage.format("InvalidColumnDefinition", "description", "gpkg_spatial_ref_sys", "notnull", "0", resultSet.getString("notnull")));
                passFlag |= 0x20;
            }
            Assert.assertTrue((passFlag & 0x3F) == 63, ErrorMessage.format("MissingColumn", "gpkg_spatial_ref_sys"));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 11")
    public void requiredSrsEntries() throws SQLException {
        ResultSet srsDefaultValue;
        try (Statement statement = this.databaseConnection.createStatement();){
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4326 AND (organization = 'EPSG' OR organization = 'epsg');");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoGeographicSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = -1 AND organization = 'NONE' AND organization_coordsys_id = -1 AND definition = 'undefined';");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoUndefinedCartesianSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        statement = this.databaseConnection.createStatement();
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = 0 AND organization = 'NONE' AND organization_coordsys_id =  0 AND definition = 'undefined';");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoUndefinedGeographicSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 12")
    public void checkContentSrs() throws SQLException {
        this.checkContentSrs("'tiles','features'");
    }

    protected void checkContentSrs(String types) throws SQLException {
        String query = "SELECT DISTINCT gc.srs_id, srs.srs_id FROM gpkg_contents AS gc LEFT OUTER JOIN gpkg_spatial_ref_sys AS srs ON srs.srs_id = gc.srs_id WHERE gc.data_type IN(" + types + ")";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefined = statement.executeQuery(query);){
            LinkedList<String> invalidSrsIds = new LinkedList<String>();
            while (srsDefined.next()) {
                if (srsDefined.getString(2) != null) continue;
                invalidSrsIds.add(srsDefined.getString(1));
            }
            Assert.assertTrue(invalidSrsIds.isEmpty(), ErrorMessage.format("UndefinedSrs", invalidSrsIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

