/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.SuiteAttribute;
import org.opengis.cite.kml2.util.HttpClientUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonFixture {
    public static final String ROOT_PKG_PATH = "/org/opengis/cite/kml2/";
    protected Client client;
    protected ClientRequest request;
    protected ClientResponse response;
    protected Document kmlDoc;
    protected NodeList targetElements;
    protected int conformanceLevel = 1;

    public void setTargetElements(NodeList targetElements) {
        this.targetElements = targetElements;
    }

    protected void findTargetElements(String ... localNames) {
        StringBuilder xpath = new StringBuilder();
        Object[] elemNames = localNames;
        for (int i = 0; i < elemNames.length; ++i) {
            xpath.append(String.format("//kml:%s[not(@targetId)]", elemNames[i]));
            if (i >= elemNames.length - 1) continue;
            xpath.append(" | ");
        }
        try {
            this.targetElements = XMLUtils.evaluateXPath(this.kmlDoc, xpath.toString(), null);
        }
        catch (XPathExpressionException xpe) {
            throw new AssertionError((Object)xpe);
        }
        if (this.targetElements.getLength() == 0) {
            throw new SkipException(String.format("No KML elements (%s) found outside of update context.", Arrays.toString(elemNames)));
        }
    }

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.CLIENT.getName());
        if (null != obj) {
            this.client = (Client)Client.class.cast(obj);
        }
        if (null == (obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName()))) {
            throw new SkipException("Test subject not found in ITestContext.");
        }
        this.kmlDoc = (Document)Document.class.cast(obj);
        obj = testContext.getSuite().getAttribute(SuiteAttribute.LEVEL.getName());
        if (null != obj) {
            this.conformanceLevel = (Integer)Integer.class.cast(obj);
        }
    }

    @BeforeMethod
    public void clearMessages() {
        this.request = null;
        this.response = null;
    }

    public Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        return HttpClientUtils.getResponseEntityAsDocument(response, targetURI);
    }

    public ClientRequest buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        return HttpClientUtils.buildGetRequest(endpoint, qryParams, mediaTypes);
    }

    @DataProvider(name="targetElementsProvider")
    protected Iterator<Object> targetElementsProvider() {
        return new TargetElementsIterator();
    }

    protected class TargetElementsIterator
    implements Iterator<Object> {
        private Iterator<Node> nodeItr;

        public TargetElementsIterator() {
            this.nodeItr = XMLUtils.asList(CommonFixture.this.targetElements).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.nodeItr.hasNext();
        }

        @Override
        public Object next() {
            return new Object[]{this.nodeItr.next()};
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

