/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.kml2.CommonFeatureTests;
import org.opengis.cite.kml2.SuiteAttribute;
import org.opengis.cite.kml2.util.KMLUtils;
import org.opengis.cite.kml2.validation.SchemaChecker;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContainerTests
extends CommonFeatureTests {
    private SchemaChecker schemaChecker = new SchemaChecker();

    @BeforeSuite
    public void findSharedStyles(ITestContext testContext) {
        Document kmlDoc = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        DOMSource kmlSource = new DOMSource(kmlDoc, kmlDoc.getBaseURI());
        Set<String> sharedStyles = KMLUtils.findElementIdentifiers(kmlSource, "//kml:Document/kml:Style | //kml:Document/kml:StyleMap");
        testContext.getSuite().setAttribute(SuiteAttribute.SHARED_STYLES.getName(), sharedStyles);
    }

    @BeforeSuite
    public void findCustomSchemas(ITestContext testContext) {
        Document kmlDoc = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        DOMSource kmlSource = new DOMSource(kmlDoc, kmlDoc.getBaseURI());
        Set<String> customSchemas = KMLUtils.findElementIdentifiers(kmlSource, "//kml:Document/kml:Schema");
        testContext.getSuite().setAttribute(SuiteAttribute.CUSTOM_SCHEMAS.getName(), customSchemas);
    }

    @BeforeClass
    public void findContainerElements() {
        this.findTargetElements("Folder", "Document");
    }

    @Test(description="ATC-119")
    public void validSchema() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element container = (Element)this.targetElements.item(i);
            if (!container.getLocalName().equals("Document")) continue;
            NodeList schemaList = container.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Schema");
            for (int j = 0; j < schemaList.getLength(); ++j) {
                Assert.assertTrue((boolean)this.schemaChecker.isValid(schemaList.item(j)), (String)this.schemaChecker.getErrorMessages());
            }
        }
    }
}

