/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.SuiteAttribute;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class KmlResourceTests
extends CommonFixture {
    private Map<String, Schema> kmlSchemas;

    @BeforeClass
    public void getKMLSchemas(ITestContext testContext) {
        this.kmlSchemas = new HashMap<String, Schema>();
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.KML22_SCHEMA.getName());
        this.kmlSchemas.put("2.2", (Schema)Schema.class.cast(obj));
        obj = testContext.getSuite().getAttribute(SuiteAttribute.KML23_SCHEMA.getName());
        this.kmlSchemas.put("2.3", (Schema)Schema.class.cast(obj));
    }

    @Test(description="ATC-102")
    public void isSchemaValid() {
        String kmlVer = this.kmlDoc.getDocumentElement().getAttribute("version");
        Schema kmlSchema = kmlVer.startsWith("2.3") ? this.kmlSchemas.get("2.3") : this.kmlSchemas.get("2.2");
        Validator validator = kmlSchema.newValidator();
        DOMSource kmlSource = new DOMSource(this.kmlDoc);
        kmlSource.setSystemId(this.kmlDoc.getDocumentURI());
        ETSAssert.assertSchemaValid(validator, kmlSource);
    }
}

