/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.validation.CoordinatesValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class LineStringTests
extends CommonFixture {
    private CoordinatesValidator coordsValidator = new CoordinatesValidator();

    @BeforeClass
    public void findLineStringElements() {
        this.findTargetElements("LineString");
    }

    @Test(description="ATC-103, ATC-115")
    public void validLineStringCoordinates() {
        JTSGeometryBuilder geomBuilder = new JTSGeometryBuilder();
        Polygon crsPolygon = geomBuilder.buildPolygon(new Envelope(-180.0, 180.0, -90.0, 90.0));
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element line = (Element)this.targetElements.item(i);
            Assert.assertTrue((boolean)this.coordsValidator.isValid(line), (String)this.coordsValidator.getErrorMessages());
            LineString jtsLine = geomBuilder.buildLineString(line);
            Assert.assertTrue((boolean)crsPolygon.covers((Geometry)jtsLine), (String)ErrorMessage.format("OutsideCRS", jtsLine.toText()));
        }
    }

    @Test(description="ATC-112, ATC-113")
    public void validAltitudeMode() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element line = (Element)this.targetElements.item(i);
            ETSAssert.assertValidAltitudeMode(line);
        }
    }
}

