/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.CoordinatesValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class LinearRingTests
extends CommonFixture {
    private CoordinatesValidator coordsValidator = new CoordinatesValidator();

    @BeforeClass
    public void findLinearRingElements() {
        this.findTargetElements("LinearRing");
    }

    @Test(description="ATC-103, ATC-116")
    public void validLinearRingCoordinates() {
        JTSGeometryBuilder geomBuilder = new JTSGeometryBuilder();
        Polygon crsPolygon = geomBuilder.buildPolygon(new Envelope(-180.0, 180.0, -90.0, 90.0));
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element ring = (Element)this.targetElements.item(i);
            Assert.assertTrue((boolean)this.coordsValidator.isValid(ring), (String)this.coordsValidator.getErrorMessages());
            LinearRing jtsRing = null;
            try {
                jtsRing = geomBuilder.buildLinearRing(ring);
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)ErrorMessage.format("OpenRing", XMLUtils.buildXPointer(ring)));
            }
            Assert.assertTrue((boolean)crsPolygon.covers((Geometry)jtsRing), (String)ErrorMessage.format("OutsideCRS", jtsRing.toText()));
        }
    }

    @Test(description="ATC-112, ATC-113")
    public void validAltitudeMode() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element ring = (Element)this.targetElements.item(i);
            String parentNodeName = ring.getParentNode().getLocalName();
            if (parentNodeName.endsWith("BoundaryIs")) continue;
            ETSAssert.assertValidAltitudeMode(ring);
        }
    }
}

