/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.LinkValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelTests
extends CommonFixture {
    private LinkValidator modelLinkValidator = new LinkValidator(MediaType.valueOf((String)"model/*"));

    @BeforeClass
    public void findModelElements() {
        this.findTargetElements("Model");
    }

    @Test(description="ATC-133, ATC-150")
    public void modelLocation() {
        JTSGeometryBuilder geomBuilder = new JTSGeometryBuilder();
        Polygon crsPolygon = geomBuilder.buildPolygon(new Envelope(-180.0, 180.0, -90.0, 90.0));
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            NodeList location = model.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Location");
            if (location.getLength() == 0) {
                throw new AssertionError((Object)ErrorMessage.format("MissingInfosetItem", "kml:Location", XMLUtils.buildXPointer(model)));
            }
            Point jtsPoint = geomBuilder.buildPointFromLocation((Element)location.item(0));
            Assert.assertTrue((boolean)crsPolygon.covers((Geometry)jtsPoint), (String)ErrorMessage.format("OutsideCRS", jtsPoint.toText()));
        }
    }

    @Test(description="ATC-133")
    public void modelLink() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            NodeList link = model.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Link");
            if (link.getLength() == 0) {
                throw new AssertionError((Object)ErrorMessage.format("MissingInfosetItem", "kml:Link", XMLUtils.buildXPointer(model)));
            }
            Assert.assertTrue((boolean)this.modelLinkValidator.isValid(link.item(0)), (String)this.modelLinkValidator.getErrorMessages());
        }
    }

    @Test(description="ATC-131")
    public void orientation() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            Element orientation = (Element)model.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Orientation").item(0);
            if (null == orientation) continue;
            Assert.assertTrue((orientation.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "*").getLength() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "Model orientation is empty.", XMLUtils.buildXPointer(orientation)));
        }
    }

    @Test(description="ATC-129, ATC-209")
    public void resourceMap() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            Element map = (Element)model.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ResourceMap").item(0);
            if (null == map) continue;
            NodeList aliases = map.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Alias");
            if (this.conformanceLevel > 1) {
                Assert.assertTrue((aliases.getLength() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "ResourceMap is empty.", XMLUtils.buildXPointer(map)));
            }
            Node modelRef = null;
            try {
                modelRef = XMLUtils.evaluateXPath(model, "kml:Link/kml:href", null).item(0);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            URI modelURI = URI.create(modelRef.getTextContent().trim());
            if (!modelURI.isAbsolute()) {
                modelURI = URIUtils.resolveRelativeURI(model.getOwnerDocument().getBaseURI(), modelURI.toString());
            }
            for (int j = 0; j < aliases.getLength(); ++j) {
                this.assertValidAlias((Element)aliases.item(j), modelURI);
            }
        }
    }

    void assertValidAlias(Element alias, URI modelURI) {
        Element sourceHrefElem = (Element)alias.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "sourceHref").item(0);
        Assert.assertNotNull((Object)sourceHrefElem, (String)ErrorMessage.format("MissingInfosetItem", "kml:sourceHref", XMLUtils.buildXPointer(alias)));
        String sourceHref = sourceHrefElem.getTextContent().trim();
        URI sourceURI = URI.create(sourceHref);
        if (!sourceURI.isAbsolute()) {
            sourceURI = modelURI.resolve(sourceURI);
        }
        ETSAssert.assertReferentExists(sourceURI, MediaType.valueOf((String)"image/*"));
        Element targetHref = (Element)alias.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "targetHref").item(0);
        Assert.assertNotNull((Object)targetHref, (String)ErrorMessage.format("MissingInfosetItem", "kml:targetHref", XMLUtils.buildXPointer(alias)));
        URI targetURI = URI.create(targetHref.getTextContent().trim());
        if (!targetURI.isAbsolute()) {
            targetURI = URIUtils.resolveRelativeURI(alias.getOwnerDocument().getBaseURI(), targetURI.toString());
        }
        ETSAssert.assertReferentExists(targetURI, MediaType.valueOf((String)"image/*"));
    }
}

