/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.UpdateValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NetworkLinkControlTests
extends CommonFixture {
    private UpdateValidator updateValidator = new UpdateValidator();

    @BeforeClass
    public void findNetworkLinkControlElements() {
        this.findTargetElements("NetworkLinkControl");
    }

    @Test(dataProvider="targetElementsProvider", description="ATC-120")
    public void refreshPeriod(Node linkControl) {
        Node refresh = ((Element)Element.class.cast(linkControl)).getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "minRefreshPeriod").item(0);
        if (null == refresh) {
            return;
        }
        Assert.assertTrue((Double.parseDouble(refresh.getTextContent()) >= 0.0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "kml:minRefreshPeriod >= 0", XMLUtils.buildXPointer(linkControl)));
    }

    @Test(dataProvider="targetElementsProvider", description="ATC-122, ATC-123")
    public void validUpdate(Node linkControlNode) {
        Node updateNode = ((Element)Element.class.cast(linkControlNode)).getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Update").item(0);
        if (null == updateNode) {
            return;
        }
        Assert.assertTrue((boolean)this.updateValidator.isValid(updateNode), (String)this.updateValidator.getErrorMessages());
    }
}

