/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import javax.ws.rs.core.MediaType;
import org.opengis.cite.kml2.CommonFeatureTests;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.LinkValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetworkLinkTests
extends CommonFeatureTests {
    private LinkValidator linkValidator = new LinkValidator(MediaType.valueOf((String)"application/vnd.google-earth.kml+xml"), MediaType.valueOf((String)"application/vnd.google-earth.kmz"));

    @BeforeClass
    public void findNetworkLinkElements() {
        this.findTargetElements("NetworkLink");
    }

    @Test(description="ATC-110")
    public void validLink() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element networkLink = (Element)this.targetElements.item(i);
            NodeList link = networkLink.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Link");
            if (link.getLength() == 0) {
                throw new AssertionError((Object)ErrorMessage.format("MissingInfosetItem", "kml:Link", XMLUtils.buildXPointer(networkLink)));
            }
            Assert.assertTrue((boolean)this.linkValidator.isValid(link.item(0)), (String)this.linkValidator.getErrorMessages());
        }
    }
}

