/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.net.URL;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.kml2.CommonFeatureTests;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.GeoExtentValidator;
import org.opengis.cite.kml2.validation.LinkValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OverlayTests
extends CommonFeatureTests {
    private LinkValidator linkValidator = new LinkValidator(MediaType.valueOf((String)"image/*"));
    private GeoExtentValidator geoExtentValidator = new GeoExtentValidator();

    @BeforeClass
    public void findOverlayElements() {
        this.findTargetElements("GroundOverlay", "ScreenOverlay", "PhotoOverlay");
    }

    @Test(description="ATC-110, ATC-118")
    public void overlayIcon() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            Node icon = overlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Icon").item(0);
            if (null == icon) continue;
            Assert.assertTrue((boolean)this.linkValidator.isValid(icon), (String)this.linkValidator.getErrorMessages());
        }
    }

    @Test(description="ATC-111")
    public void groundOverlayExtent() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            if (!overlay.getLocalName().equals("GroundOverlay")) continue;
            Node extent = overlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LatLonBox").item(0);
            if (null == extent) {
                extent = overlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LatLonQuad").item(0);
            }
            Assert.assertNotNull((Object)extent, (String)ErrorMessage.format("MissingInfosetItem", "kml:LatLonBox or kml:LatLonQuad", XMLUtils.buildXPointer(overlay)));
            Assert.assertTrue((boolean)this.geoExtentValidator.validGeoExtent(extent), (String)this.geoExtentValidator.getErrorMessages());
        }
    }

    @Test(description="ATC-119, ATC-132, ATC-134")
    public void checkOverlayConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-overlay.sch");
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            ETSAssert.assertSchematronValid(schRef, new DOMSource(overlay));
        }
    }
}

