/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.SuiteAttribute;
import org.opengis.cite.kml2.util.TestSuiteLogger;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeSuite;
import org.w3c.dom.Document;

public class SuitePreconditions {
    @BeforeSuite(description="ATC-101")
    public void isKMLDocument(ITestContext testContext) {
        Object sut = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null == sut || !Document.class.isInstance(sut)) {
            String msg = String.format("Value of test suite attribute %s is missing or does not refer to an XML resource.", SuiteAttribute.TEST_SUBJECT.getName());
            TestSuiteLogger.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
        Document doc = (Document)Document.class.cast(sut);
        ETSAssert.assertQualifiedName(doc.getDocumentElement(), new QName("http://www.opengis.net/kml/2.2", "kml"));
    }

    @BeforeSuite
    public void checkVersion(ITestContext testContext) {
        Object ver = testContext.getSuite().getAttribute(SuiteAttribute.KML_VERSION.getName());
        if (null == ver) {
            String msg = String.format("Value of test suite attribute %s is missing.", SuiteAttribute.KML_VERSION.getName());
            TestSuiteLogger.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
        String version = ver.toString();
        Assert.assertTrue((version.startsWith("2.2") || version.startsWith("2.3") ? 1 : 0) != 0, (String)ErrorMessage.format("UnsupportedVersion", version));
    }
}

