/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeSpanTests
extends CommonFixture {
    DateTimeFormatter timeFormatter = ISODateTimeFormat.dateTimeParser();

    @BeforeClass
    public void findTimeSpanElements() {
        this.findTargetElements("TimeSpan");
    }

    @Test(description="ATC-104")
    public void validTimeSpan() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element span = (Element)this.targetElements.item(i);
            NodeList nodes = null;
            try {
                nodes = XMLUtils.evaluateXPath(span, "kml:begin | kml:end", null);
                Assert.assertFalse((nodes.getLength() == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("EmptyTimeSpan", XMLUtils.buildXPointer(span)));
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            if (nodes.getLength() != 2 || this.isValidDefiniteTimeInterval(nodes)) continue;
            ValidationError err = new ValidationError(ErrorSeverity.ERROR, ErrorMessage.get("TimeSpanInterval"), null, -1, -1, XMLUtils.buildXPointer(span));
            throw new AssertionError(err);
        }
    }

    boolean isValidDefiniteTimeInterval(NodeList timeInstants) {
        HashMap<String, DateTime> instants = new HashMap<String, DateTime>();
        for (int i = 0; i < timeInstants.getLength(); ++i) {
            Node instant = timeInstants.item(i);
            try {
                DateTime dateTime = this.timeFormatter.parseDateTime(instant.getTextContent().trim());
                instants.put(instant.getLocalName(), dateTime);
                continue;
            }
            catch (IllegalArgumentException x) {
                instants.put(instant.getLocalName(), null);
            }
        }
        return ((DateTime)instants.get("end")).isAfter((ReadableInstant)instants.get("begin"));
    }
}

