/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c2;

import java.net.URL;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.util.XMLUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StyleTests
extends CommonFixture {
    @BeforeClass
    public void findStyleSelectors() {
        this.findTargetElements("Style", "StyleMap");
    }

    @Test(description="ATC-201,-217,-220,-222,-223,-224,-227")
    public void checkStyleConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-style.sch");
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element style = (Element)this.targetElements.item(i);
            ETSAssert.assertSchematronValid(schRef, new DOMSource(style));
        }
    }

    public void entitiesInBalloonStyle() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element style = (Element)this.targetElements.item(i);
            NodeList textNodes = null;
            try {
                textNodes = XMLUtils.evaluateXPath(style, "//kml:BalloonStyle/kml:text", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            for (int j = 0; j < textNodes.getLength(); ++j) {
            }
        }
    }
}

