/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JTSGeometryBuilder {
    private GeometryFactory geomFactory = new GeometryFactory();

    public Point buildPoint(Element point) {
        if (!point.getLocalName().equals("Point")) {
            throw new IllegalArgumentException("Element does not represent a Point.");
        }
        String[] tuple = point.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates").item(0).getTextContent().trim().split(",");
        double alt = tuple.length > 2 ? Double.parseDouble(tuple[2]) : 0.0;
        Coordinate coord = new Coordinate(Double.parseDouble(tuple[0]), Double.parseDouble(tuple[1]), alt);
        return this.geomFactory.createPoint(coord);
    }

    public Point buildPointFromLocation(Element location) {
        if (!location.getLocalName().equals("Location")) {
            throw new IllegalArgumentException("Element does not represent a Location.");
        }
        NodeList nodes = location.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "longitude");
        double lon = nodes.getLength() > 0 ? Double.parseDouble(nodes.item(0).getTextContent()) : 0.0;
        nodes = location.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "latitude");
        double lat = nodes.getLength() > 0 ? Double.parseDouble(nodes.item(0).getTextContent()) : 0.0;
        nodes = location.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitude");
        double alt = nodes.getLength() > 0 ? Double.parseDouble(nodes.item(0).getTextContent()) : 0.0;
        Coordinate coord = new Coordinate(lon, lat, alt);
        return this.geomFactory.createPoint(coord);
    }

    public LineString buildLineString(Element line) {
        if (!line.getLocalName().equals("LineString")) {
            throw new IllegalArgumentException("Element does not represent a LineString.");
        }
        List<Coordinate> coordList = this.createCoordinateList(line.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates").item(0));
        return this.geomFactory.createLineString(coordList.toArray(new Coordinate[coordList.size()]));
    }

    public LinearRing buildLinearRing(Element ring) {
        if (!ring.getLocalName().equals("LinearRing")) {
            throw new IllegalArgumentException("Element does not represent a LinearRing.");
        }
        List<Coordinate> coordList = this.createCoordinateList(ring.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates").item(0));
        return this.geomFactory.createLinearRing(coordList.toArray(new Coordinate[coordList.size()]));
    }

    public Polygon buildPolygon(Element polygon) {
        if (!polygon.getLocalName().equals("Polygon")) {
            throw new IllegalArgumentException("Element does not represent a Polygon.");
        }
        LinearRing outerRing = null;
        NodeList rings = null;
        try {
            rings = XMLUtils.evaluateXPath(polygon, "kml:outerBoundaryIs/kml:LinearRing", null);
            outerRing = this.buildLinearRing((Element)rings.item(0));
            rings = XMLUtils.evaluateXPath(polygon, "kml:innerBoundaryIs/kml:LinearRing", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Polygon outerPolygon = this.geomFactory.createPolygon(outerRing);
        LinearRing[] innerRings = new LinearRing[rings.getLength()];
        for (int i = 0; i < rings.getLength(); ++i) {
            LinearRing innerRing = this.buildLinearRing((Element)rings.item(i));
            if (!outerPolygon.contains((Geometry)innerRing)) {
                throw new IllegalArgumentException(String.format("Inner boundary [%d] not inside outer boundary.", i + 1));
            }
            innerRings[i] = innerRing;
        }
        return this.geomFactory.createPolygon(outerRing, innerRings);
    }

    public Polygon buildPolygon(Envelope env) {
        return (Polygon)this.geomFactory.toGeometry(env);
    }

    public Polygon buildPolygonFromCoordinates(Node coords) {
        List<Coordinate> coordList = this.createCoordinateList(coords);
        Coordinate lastCord = coordList.get(coordList.size() - 1);
        if (!coordList.get(0).equals2D(lastCord)) {
            coordList.add(new Coordinate(coordList.get(0)));
        }
        Polygon polygon = this.geomFactory.createPolygon(coordList.toArray(new Coordinate[coordList.size()]));
        return polygon;
    }

    List<Coordinate> createCoordinateList(Node coords) {
        String[] tuples;
        if (!coords.getLocalName().equals("coordinates")) {
            throw new IllegalArgumentException("Node does not represent a list of coordinates.");
        }
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        for (String tuple : tuples = coords.getTextContent().trim().split("\\s+")) {
            String[] coordTuple = tuple.trim().split(",");
            double alt = coordTuple.length > 2 ? Double.parseDouble(coordTuple[2]) : 0.0;
            Coordinate coord = new Coordinate(Double.parseDouble(coordTuple[0]), Double.parseDouble(coordTuple[1]), alt);
            coordList.add(coord);
        }
        return coordList;
    }
}

