/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.kml2.Namespaces;
import org.opengis.cite.kml2.util.TestSuiteLogger;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.cite.xerces.impl.Constants;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ValidationUtils {
    static final String ROOT_PKG = "/org/opengis/cite/kml2/";
    private static final XMLCatalogResolver SCH_RESOLVER = ValidationUtils.initCatalogResolver();

    private static XMLCatalogResolver initCatalogResolver() {
        return (XMLCatalogResolver)ValidationUtils.createSchemaResolver(Namespaces.SCH);
    }

    public static LSResourceResolver createSchemaResolver(URI schemaLanguage) {
        String catalogFileName = schemaLanguage.equals(Namespaces.XSD) ? "schema-catalog.xml" : "schematron-catalog.xml";
        URL catalogURL = ValidationUtils.class.getResource(ROOT_PKG + catalogFileName);
        XMLCatalogResolver resolver = new XMLCatalogResolver();
        resolver.setCatalogList(new String[]{catalogURL.toString()});
        return resolver;
    }

    public static SchematronValidator buildSchematronValidator(String schemaRef, String phase) {
        StreamSource source = null;
        try {
            String catalogRef = SCH_RESOLVER.resolveSystem(schemaRef.toString());
            source = null != catalogRef ? new StreamSource(URI.create(catalogRef).toString()) : new StreamSource(schemaRef);
        }
        catch (IOException x) {
            TestSuiteLogger.log(Level.WARNING, "Error reading Schematron schema catalog.", x);
        }
        SchematronValidator validator = null;
        try {
            validator = new SchematronValidator((Source)source, phase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Error creating Schematron validator.", e);
        }
        return validator;
    }

    public static Set<URI> extractSchemaReferences(Source source, String baseURI) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(source);
        StartElement docElem = reader.nextTag().asStartElement();
        Attribute schemaLoc = docElem.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        if (null == schemaLoc) {
            throw new RuntimeException("No xsi:schemaLocation attribute found. See ISO 19136, A.3.1.");
        }
        Object[] uriValues = schemaLoc.getValue().split("\\s+");
        if (uriValues.length % 2 != 0) {
            throw new RuntimeException("xsi:schemaLocation attribute contains an odd number of URI values:\n" + Arrays.toString(uriValues));
        }
        HashSet<URI> schemaURIs = new HashSet<URI>();
        for (int i = 0; i < uriValues.length; i += 2) {
            URI schemaURI = null;
            if (!URI.create((String)uriValues[i + 1]).isAbsolute() && null != source.getSystemId()) {
                String schemaRef = URIUtils.resolveRelativeURI(source.getSystemId(), (String)uriValues[i + 1]).toString();
                if (schemaRef.startsWith("file") && !new File(schemaRef).exists() && null != baseURI) {
                    schemaRef = URIUtils.resolveRelativeURI(baseURI, (String)uriValues[i + 1]).toString();
                }
                schemaURI = URI.create(schemaRef);
            } else {
                schemaURI = URI.create((String)uriValues[i + 1]);
            }
            schemaURIs.add(schemaURI);
        }
        return schemaURIs;
    }

    public static Schema createKMLSchema(String version) {
        URL schemaURL;
        SchemaFactory factory;
        Schema kmlSchema = null;
        switch (version) {
            case "2.3": {
                factory = SchemaFactory.newInstance(Constants.W3C_XML_SCHEMA11_NS_URI, "org.opengis.cite.xerces.jaxp.validation.XMLSchema11Factory", null);
                schemaURL = ValidationUtils.class.getResource("/org/opengis/cite/kml2/xsd/opengis/kml/2.3.0/ogckml23_xsd11.xsd");
                break;
            }
            default: {
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaURL = ValidationUtils.class.getResource("/org/opengis/cite/kml2/xsd/opengis/kml/2.2.0/ogckml22.xsd");
            }
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        factory.setErrorHandler((ErrorHandler)errHandler);
        URL catalogUrl = ValidationUtils.class.getResource("/org/opengis/cite/kml2/schema-catalog.xml");
        XMLCatalogResolver resolver = new XMLCatalogResolver(new String[]{catalogUrl.toString()});
        factory.setResourceResolver((LSResourceResolver)resolver);
        try {
            kmlSchema = factory.newSchema(schemaURL);
        }
        catch (SAXException x) {
            TestSuiteLogger.log(Level.WARNING, String.format("Failed to process XML Schema at %s \n %s", schemaURL, errHandler.toString()), x);
        }
        if (errHandler.errorsDetected()) {
            TestSuiteLogger.log(Level.WARNING, String.format("Failed to process XML Schema at %s \n %s", schemaURL, errHandler.toString()));
        }
        return kmlSchema;
    }
}

