/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import org.opengis.cite.kml2.AltitudeMode;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.KMLUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoordinatesValidator {
    ValidationErrorHandler errHandler = new ValidationErrorHandler();

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public void reset() {
        this.errHandler.reset();
    }

    public boolean isValid(Node node) {
        this.errHandler.reset();
        Element elem = (Element)node;
        NodeList coords = elem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates");
        if (coords.getLength() == 0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.get("MissingCoords"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
            return false;
        }
        String[] tuples = coords.item(0).getTextContent().trim().split("\\s+");
        switch (node.getLocalName()) {
            case "Point": {
                if (tuples.length == 1) break;
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("PointCoords", tuples.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                break;
            }
            case "LineString": {
                if (tuples.length >= 2) break;
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("LineCoords", tuples.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                break;
            }
            case "LinearRing": {
                if (tuples.length >= 4) break;
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("RingCoords", tuples.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                break;
            }
            case "LatLonQuad": {
                if (tuples.length == 4) break;
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("QuadCoords", tuples.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                break;
            }
        }
        for (int i = 0; i < tuples.length; ++i) {
            String[] tuple = tuples[i].trim().split(",");
            if (tuple.length < 2 || tuple.length > 3) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("CoordDim", i, "2-3", tuple.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                continue;
            }
            AltitudeMode altMode = KMLUtils.getAltitudeMode(elem);
            if (altMode != AltitudeMode.CLAMP_TO_GROUND && tuple.length != 3) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("CoordDim", i, "3 (altitudeMode is not 'clampToGround')", tuple.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                continue;
            }
            for (String val : tuple) {
                try {
                    Float.parseFloat(val);
                }
                catch (NumberFormatException e) {
                    this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("NaN", val), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
                }
            }
        }
        return !this.errHandler.errorsDetected();
    }
}

