/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.LinkValidator;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleChecker {
    ValidationErrorHandler errHandler = new ValidationErrorHandler();
    private LinkValidator linkChecker = new LinkValidator(MediaType.valueOf((String)"image/*"));
    static final Set<String> NETWORK_LINK_STATE_SET;

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public boolean isValid(Node node) {
        if (!node.getLocalName().equals("Style")) {
            throw new IllegalArgumentException("Not a Style element: " + node.getLocalName());
        }
        this.errHandler.reset();
        Element style = (Element)node;
        this.checkIconStyle(style);
        this.checkListStyle(style);
        return !this.errHandler.errorsDetected();
    }

    void checkIconStyle(Element style) {
        Node icon = null;
        try {
            icon = XMLUtils.evaluateXPath(style, "kml:IconStyle/kml:Icon", null).item(0);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        if (null != icon && !this.linkChecker.isValid(icon)) {
            Iterator<ValidationError> errors = this.linkChecker.getErrors();
            while (errors.hasNext()) {
                ValidationError err = errors.next();
                this.errHandler.addError(err.getSeverity(), err.getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(icon)));
            }
        }
    }

    void checkListStyle(Element style) {
        NodeList itemIcons = null;
        try {
            itemIcons = XMLUtils.evaluateXPath(style, "kml:ListStyle/kml:ItemIcon", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        for (int i = 0; i < itemIcons.getLength(); ++i) {
            QName feature;
            Element itemIcon = (Element)itemIcons.item(i);
            Node href = itemIcon.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href").item(0);
            URI uri = URI.create(href.getTextContent().trim());
            if (!uri.isAbsolute()) {
                uri = uri.resolve(style.getOwnerDocument().getBaseURI());
            }
            try {
                ETSAssert.assertReferentExists(uri, MediaType.valueOf((String)"image/*"));
            }
            catch (AssertionError e) {
                this.errHandler.addError(ErrorSeverity.ERROR, ((Throwable)((Object)e)).getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(itemIcon)));
            }
            Node state = itemIcon.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "state").item(0);
            if (null == state) continue;
            List<String> stateList = Arrays.asList(state.getTextContent().trim().split("\\s"));
            HashSet<String> states = new HashSet<String>(stateList);
            states.retainAll(NETWORK_LINK_STATE_SET);
            if (states.isEmpty() || !style.getAttribute("id").isEmpty() || (feature = XMLUtils.getQName(style.getParentNode())).equals(new QName("http://www.opengis.net/kml/2.2", "NetworkLink"))) continue;
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-136] ListStyle applies to NetworkLink, not " + feature), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(itemIcon)));
        }
    }

    static {
        HashSet<String> aSet = new HashSet<String>();
        aSet.add("error");
        aSet.add("fetching0");
        aSet.add("fetching1");
        aSet.add("fetching2");
        NETWORK_LINK_STATE_SET = Collections.unmodifiableSet(aSet);
    }
}

