/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpdateValidator {
    ValidationErrorHandler errHandler = new ValidationErrorHandler();

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public boolean isValid(Node updateNode) {
        this.errHandler.reset();
        Element update = (Element)updateNode;
        Element targetUri = (Element)update.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "targetHref").item(0);
        try {
            if (!targetUri.getTextContent().trim().isEmpty()) {
                ETSAssert.assertReferentExists(URI.create(targetUri.getTextContent().trim()), MediaType.valueOf((String)"application/vnd.google-earth.kml+xml"), MediaType.valueOf((String)"application/vnd.google-earth.kmz"));
            }
            URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-update.sch");
            ETSAssert.assertSchematronValid(schRef, new DOMSource(update));
        }
        catch (AssertionError e) {
            this.errHandler.addError(ErrorSeverity.ERROR, ((Throwable)((Object)e)).getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(update)));
        }
        return !this.errHandler.errorsDetected();
    }
}

