/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import org.opengis.cite.kml22.SuiteAttribute;
import org.opengis.cite.kml22.TestRunArg;
import org.opengis.cite.kml22.util.KMLUtils;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.ValidationUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        Reporter.clear();
        Schema kmlSchema = ValidationUtils.createKMLSchema();
        if (null != kmlSchema) {
            suite.setAttribute(SuiteAttribute.KML_SCHEMA.getName(), kmlSchema);
        }
        this.processSuiteParameters(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        Reporter.log("Test suite parameters:");
        Reporter.log(suite.getXmlSuite().getAllParameters().toString());
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        Integer level = new Integer(1);
        if (null != params.get(TestRunArg.ICS.toString())) {
            try {
                level = Integer.valueOf(params.get(TestRunArg.ICS.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        suite.setAttribute(SuiteAttribute.LEVEL.getName(), level);
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to access resource located at " + iutRef, iox);
        }
        Document kmlDoc = null;
        try {
            try {
                kmlDoc = URIUtils.parseURI(entityFile.toURI());
            }
            catch (SAXException e) {
                kmlDoc = KMLUtils.extractKMLFromArchive(entityFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read KML document from file at " + entityFile.toURI(), e);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), kmlDoc);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(kmlDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }
}

