/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkTests
extends BaseFixture {
    private Client client;

    @BeforeClass
    public void initHttpClient() {
        this.client = Client.create();
        this.client.setFollowRedirects(true);
        this.client.addFilter(new LoggingFilter(TestSuiteLogger.getLogger()));
    }

    @Test(description="Implements ATC 9")
    public void verifyLinkRefreshInterval() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link | //kml:Icon", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            boolean refreshIntervalExists;
            Element link = (Element)linkNodes.item(i);
            NodeList refreshIntervalNodes = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "refreshInterval");
            boolean bl = refreshIntervalExists = refreshIntervalNodes.getLength() > 0;
            if (!refreshIntervalExists) continue;
            Double refreshInterval = Double.valueOf(refreshIntervalNodes.item(0).getTextContent());
            if (refreshInterval == null) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
                continue;
            }
            if (!(refreshInterval <= 0.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 9")
    public void verifyLinkViewRefreshTime() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link | //kml:Icon", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            boolean viewRefreshTimeExists;
            Element link = (Element)linkNodes.item(i);
            NodeList viewRefreshTimeNodes = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewRefreshTime");
            boolean bl = viewRefreshTimeExists = viewRefreshTimeNodes.getLength() > 0;
            if (!viewRefreshTimeExists) continue;
            Double viewRefreshTime = Double.valueOf(viewRefreshTimeNodes.item(0).getTextContent());
            if (viewRefreshTime == null) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err3", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
                continue;
            }
            if (!(viewRefreshTime <= 0.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err4", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 9")
    public void verifyLinkViewBoundScale() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link | //kml:Icon", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            boolean viewBoundScaleExists;
            Element link = (Element)linkNodes.item(i);
            NodeList viewBoundScaleNodes = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewBoundScale");
            boolean bl = viewBoundScaleExists = viewBoundScaleNodes.getLength() > 0;
            if (!viewBoundScaleExists) continue;
            Double viewBoundScale = Double.valueOf(viewBoundScaleNodes.item(0).getTextContent());
            if (viewBoundScale == null) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err5", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
                continue;
            }
            if (!(viewBoundScale <= 0.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkElements.err6", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 10")
    public void verifyLinkReferent() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link | //kml:Icon", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            Element linkNode = (Element)linkNodes.item(i);
            Element parent = (Element)linkNode.getParentNode();
            String hrefUrl = this.getLinkHref(linkNode, errHandler);
            if (hrefUrl == null || hrefUrl.equals("")) continue;
            URI hrefUri = URI.create(hrefUrl.trim());
            if (parent.getNamespaceURI().equals("http://www.opengis.net/kml/2.2") && parent.getLocalName().equals("NetworkLink")) {
                this.checkNetworkLinkReferent(linkNode, hrefUri, errHandler);
                continue;
            }
            if (parent.getNamespaceURI().equals("http://www.opengis.net/kml/2.2") && parent.getLocalName().equals("Model")) {
                this.checkModelReferent(linkNode, hrefUri, errHandler);
                continue;
            }
            if (parent.getNamespaceURI().equals("http://www.opengis.net/kml/2.2") && (parent.getLocalName().equals("GroundOverlay") || parent.getLocalName().equals("ScreenOverlay") || parent.getLocalName().equals("PhotoOverlay"))) {
                this.checkOverlayIconReferent(linkNode, hrefUrl, errHandler);
                continue;
            }
            if (!TestSuiteLogger.isLoggable(Level.FINER)) continue;
            TestSuiteLogger.log(Level.FINER, "Found Link element with unknown parent: " + parent.getNamespaceURI() + ":" + parent.getLocalName());
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 18")
    public void verifyIconReferent() {
        NodeList iconNodes = null;
        try {
            iconNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Icon[@href]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < iconNodes.getLength(); ++i) {
            Element iconNode = (Element)iconNodes.item(i);
            String hrefUrl = this.getLinkHref(iconNode, errHandler);
            if (hrefUrl == null || hrefUrl.isEmpty()) continue;
            this.checkOverlayIconReferent(iconNode, hrefUrl, errHandler);
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 20")
    public void verifyNetworkLinkControlRefresh() {
        NodeList minRefreshNodes = null;
        try {
            minRefreshNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:NetworkLinkControl/kml:minRefreshPeriod", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < minRefreshNodes.getLength(); ++i) {
            Node minRefresh = minRefreshNodes.item(i);
            if (!(Double.valueOf(minRefresh.getTextContent().trim()) < 0.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.NetworkLinkControl.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(minRefresh.getParentNode())));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 22")
    public void verifyUpdateTargetExists() {
        NodeList updateTargets = null;
        try {
            updateTargets = XMLUtils.evaluateXPath(this.testSubject, "//kml:Update/kml:targetHref", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < updateTargets.getLength(); ++i) {
            Node updateTarget = updateTargets.item(i);
            try {
                ETSAssert.assertReferentExists("text()", updateTarget, this.client, "application/xml", "application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz");
            }
            catch (AssertionError e) {
                this.addHrefError(updateTarget, ((Throwable)((Object)e)).getMessage(), errHandler);
            }
            ETSAssert.assertValidUpdate(updateTarget.getParentNode());
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    @Test(description="Implements ATC 40")
    public void verifyLinkHasHref() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link[not(ancestor::kml:Update)] | //kml:Icon[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            Element link = (Element)linkNodes.item(i);
            if (link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Link.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
        }
        Assert.assertFalse(errHandler.errorsDetected(), errHandler.toString());
    }

    void checkOverlayIconReferent(Node linkNode, String href, ValidationErrorHandler errHandler) {
        URI uriRef = URI.create(href);
        try {
            ETSAssert.assertReferentExists(uriRef, linkNode.getOwnerDocument().getBaseURI(), this.client, "image/*");
        }
        catch (AssertionError e) {
            this.addHrefError(linkNode, ((Throwable)((Object)e)).getMessage(), errHandler);
            return;
        }
        BufferedImage image = null;
        try {
            image = this.readImageDataFromURI(uriRef);
        }
        catch (IOException iox) {
            this.addHrefError(linkNode, iox.getMessage(), errHandler);
        }
        if (null == image) {
            this.addHrefError(linkNode, "Failed to read image data from " + uriRef, errHandler);
        }
    }

    BufferedImage readImageDataFromURI(URI uriRef) throws IOException {
        BufferedImage image = null;
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            image = ImageIO.read(uriRef.toURL());
        } else {
            int status;
            WebResource resource = this.client.resource(uriRef);
            WebResource.Builder builder = resource.accept("image/*");
            ClientResponse rsp = builder.get(ClientResponse.class);
            if (null != rsp.getLocation()) {
                resource = this.client.resource(rsp.getLocation());
                rsp = resource.accept("image/*").get(ClientResponse.class);
            }
            if ((status = rsp.getStatus()) == Response.Status.OK.getStatusCode() && rsp.hasEntity()) {
                image = ImageIO.read(rsp.getEntityInputStream());
            }
        }
        return image;
    }

    void checkModelReferent(Element linkNode, URI uriRef, ValidationErrorHandler errHandler) {
        try {
            ETSAssert.assertReferentExists(".//kml:href", linkNode, this.client, "model/*", "application/octet-stream");
        }
        catch (AssertionError e) {
            this.addHrefError(linkNode, ((Throwable)((Object)e)).getMessage(), errHandler);
        }
    }

    void checkNetworkLinkReferent(Node linkNode, URI uriRef, ValidationErrorHandler errHandler) {
        try {
            ETSAssert.assertReferentExists(".//kml:href", linkNode, this.client, "application/xml", "application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz");
        }
        catch (AssertionError e) {
            this.addHrefError(linkNode, ((Throwable)((Object)e)).getMessage(), errHandler);
        }
    }

    String getLinkHref(Element linkElem, ValidationErrorHandler errHandler) {
        NodeList hrefNodes = linkElem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href");
        if (hrefNodes.getLength() == 0) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkReferents.err5", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(linkElem)));
            return null;
        }
        String href = hrefNodes.item(0).getTextContent().trim();
        if (href.contains("$")) {
            href = URIUtils.replaceImageTileParams(href);
        }
        try {
            URI uriRef = new URI(href);
            if (!uriRef.isAbsolute()) {
                String baseURI = linkElem.getOwnerDocument().getBaseURI();
                uriRef = URIUtils.resolveRelativeURI(baseURI, href);
                href = uriRef.toString();
            }
        }
        catch (URISyntaxException e) {
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkReferents.err6", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(linkElem)));
            return null;
        }
        return href;
    }

    void addHrefError(Node linkNode, String details, ValidationErrorHandler errHandler) {
        errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.LinkReferents.err1", details), new ErrorLocator(-1, -1, XMLUtils.getXPointer(linkNode.getParentNode())));
    }
}

